/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.ServiceController;

public final class MultipleRemoveListener<T>
extends AbstractServiceListener<Object> {
    private volatile int count = 1;
    private volatile int done;
    private final Callback<T> callback;
    private final T attachment;
    private static final AtomicIntegerFieldUpdater<MultipleRemoveListener> countUpdater = AtomicIntegerFieldUpdater.newUpdater(MultipleRemoveListener.class, "count");
    private static final AtomicIntegerFieldUpdater<MultipleRemoveListener> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(MultipleRemoveListener.class, "done");
    private static final Callback<LifecycleContext> LIFECYCLE_CONTEXT_CALLBACK = new Callback<LifecycleContext>(){

        @Override
        public void handleDone(LifecycleContext parameter) {
            parameter.complete();
        }
    };

    private MultipleRemoveListener(Callback<T> callback, T attachment) {
        this.callback = callback;
        this.attachment = attachment;
    }

    public static <T> MultipleRemoveListener<T> create(Callback<T> callback, T attachment) {
        return new MultipleRemoveListener<T>(callback, attachment);
    }

    public static MultipleRemoveListener<Runnable> create(Runnable task) {
        return new MultipleRemoveListener<Runnable>(new Callback<Runnable>(){

            @Override
            public void handleDone(Runnable parameter) {
                if (parameter != null) {
                    parameter.run();
                }
            }
        }, task);
    }

    public static MultipleRemoveListener<LifecycleContext> create(LifecycleContext lifecycleContext) {
        return new MultipleRemoveListener<LifecycleContext>(LIFECYCLE_CONTEXT_CALLBACK, lifecycleContext);
    }

    @Override
    public void listenerAdded(ServiceController<?> controller) {
        countUpdater.getAndIncrement(this);
    }

    @Override
    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        if (transition.enters(ServiceController.State.REMOVED)) {
            this.tick();
        }
    }

    public void done() {
        if (doneUpdater.getAndSet(this, 1) == 0) {
            this.tick();
        }
    }

    private void tick() {
        if (countUpdater.decrementAndGet(this) == 0) {
            this.callback.handleDone(this.attachment);
        }
    }

    public static interface Callback<T> {
        public void handleDone(T var1);
    }
}

