/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.storage;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.storage.AbstractCredentialStorage;
import org.picketlink.idm.credential.storage.annotations.Stored;

public class X509CertificateStorage
extends AbstractCredentialStorage {
    private String base64Cert;

    public X509CertificateStorage() {
    }

    public X509CertificateStorage(X509Certificate certificate) {
        try {
            this.base64Cert = Base64.encodeBytes((byte[])certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IdentityManagementException("Could not get Base64 representation for X509 Certificate.", e);
        }
    }

    @Stored
    public String getBase64Cert() {
        return this.base64Cert;
    }

    public void setBase64Cert(String base64Cert) {
        this.base64Cert = base64Cert;
    }
}

