/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.acl.spi;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.permission.IdentityPermission;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.permission.spi.PermissionVoter;

public class PersistentPermissionVoter
implements PermissionVoter {
    private final PartitionManager partitionManager;

    public PersistentPermissionVoter(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    @Override
    public PermissionVoter.VotingResult hasPermission(IdentityType recipient, Object resource, String operation) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient must not be null");
        }
        List<Permission> permissions = this.getPermissionManager(recipient).listPermissions(resource, operation);
        return this.checkPermission(recipient, permissions);
    }

    @Override
    public PermissionVoter.VotingResult hasPermission(IdentityType recipient, Class<?> resourceClass, Serializable identifier, String operation) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient must not be null");
        }
        List<Permission> permissions = this.getPermissionManager(recipient).listPermissions(resourceClass, identifier, operation);
        return this.checkPermission(recipient, permissions);
    }

    private PermissionManager getPermissionManager(IdentityType recipient) {
        return this.partitionManager.createPermissionManager(recipient.getPartition());
    }

    private PermissionVoter.VotingResult checkPermission(IdentityType recipient, List<Permission> permissions) {
        RelationshipManager relationshipManager = this.partitionManager.createRelationshipManager();
        for (Permission permission : permissions) {
            IdentityPermission idPermission;
            if (!(permission instanceof IdentityPermission) || !relationshipManager.inheritsPrivileges(recipient, (idPermission = (IdentityPermission)permission).getAssignee())) continue;
            return PermissionVoter.VotingResult.ALLOW;
        }
        return PermissionVoter.VotingResult.NOT_APPLICABLE;
    }
}

