/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import org.jboss.as.clustering.jgroups.LogFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLReader;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jgroups.logging.CustomLogFactory;

public class JGroupsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jgroups";

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, JGroupsModel.CURRENT.getVersion());
        new JGroupsSubsystemResourceDefinition(context.isRuntimeOnlyRegistrationValid()).register(registration);
        registration.registerXMLElementWriter((XMLElementWriter)new JGroupsSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            for (JGroupsModel model : EnumSet.complementOf(EnumSet.of(JGroupsModel.CURRENT))) {
                ModelVersion version = model.getVersion();
                TransformationDescription.Tools.register((TransformationDescription)JGroupsSubsystemResourceDefinition.buildTransformers(version), (SubsystemRegistration)registration, (ModelVersionRange)version);
            }
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (JGroupsSchema schema : JGroupsSchema.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new JGroupsSubsystemXMLReader(schema));
        }
    }

    static {
        org.jgroups.logging.LogFactory.setCustomLogFactory((CustomLogFactory)new LogFactory());
    }
}

