/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionConsumerFlowCreditMessage
extends PacketImpl {
    private long consumerID;
    private int credits;

    public SessionConsumerFlowCreditMessage(long consumerID, int credits) {
        super((byte)70);
        this.consumerID = consumerID;
        this.credits = credits;
    }

    public SessionConsumerFlowCreditMessage() {
        super((byte)70);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getCredits() {
        return this.credits;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.credits);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.credits = buffer.readInt();
    }

    @Override
    public String toString() {
        return this.getParentString() + ", consumerID=" + this.consumerID + ", credits=" + this.credits + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + this.credits;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionConsumerFlowCreditMessage)) {
            return false;
        }
        SessionConsumerFlowCreditMessage other = (SessionConsumerFlowCreditMessage)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        return this.credits == other.credits;
    }
}

