/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator.rules.mc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.resource.spi.ManagedConnection;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Rule;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.rules.mc.SecurityActions;

public class MCGetMetaData
implements Rule {
    private static final String SECTION = "6.5.5.2";

    @Override
    public List<Failure> validate(Validate v, ResourceBundle rb) {
        if (v != null && Key.MANAGED_CONNECTION == v.getKey() && ManagedConnection.class.isAssignableFrom(v.getClazz())) {
            boolean error = false;
            ValidateObject vo = null;
            if (v instanceof ValidateObject) {
                vo = (ValidateObject)v;
            }
            if (vo == null) {
                error = true;
            } else {
                try {
                    Class<?> clz = vo.getClazz();
                    Method gmd = SecurityActions.getMethod(clz, "getMetaData", null);
                    Object md = gmd.invoke(vo.getObject(), (Object[])null);
                    if (md == null) {
                        error = true;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (error) {
                ArrayList<Failure> failures = new ArrayList<Failure>(1);
                Failure failure = new Failure(1, SECTION, rb.getString("mc.MCGetMetaData"), vo.getClazz().getName());
                failures.add(failure);
                return failures;
            }
        }
        return null;
    }
}

