/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.sagas.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.RecordListIterator;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.CompletionStatus;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wscf.common.CoordinatorId;
import com.arjuna.mw.wscf.common.Qualifier;
import com.arjuna.mw.wscf.exceptions.DuplicateParticipantException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.sagas.exceptions.DuplicateSynchronizationException;
import com.arjuna.mw.wscf.model.sagas.exceptions.InvalidSynchronizationException;
import com.arjuna.mw.wscf.model.sagas.participants.Participant;
import com.arjuna.mw.wscf.model.sagas.participants.Synchronization;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.CoordinatorIdImple;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.ParticipantRecord;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.SynchronizationRecord;

public class BACoordinator
extends TwoPhaseCoordinator {
    private static final int DELISTED = 0;
    private static final int COMPLETED = 1;
    private static final int FAILED = 2;
    private CoordinatorIdImple _theId = new CoordinatorIdImple(this.get_uid());

    public BACoordinator() {
    }

    public BACoordinator(Uid recovery) {
        super(recovery);
    }

    public Outcome coordinate(CompletionStatus cs) throws WrongStateException, ProtocolViolationException, SystemException {
        return null;
    }

    public synchronized void complete() throws WrongStateException, SystemException {
        int status = this.status();
        if (status == 0) {
            if (this.pendingList != null) {
                RecordListIterator iter = new RecordListIterator(this.pendingList);
                AbstractRecord absRec = iter.iterate();
                while (absRec != null) {
                    ParticipantRecord pr;
                    if (absRec instanceof ParticipantRecord && !(pr = (ParticipantRecord)absRec).complete()) {
                        this.preventCommit();
                        wscfLogger.i18NLogger.warn_model_sagas_arjunacore_BACoordinator_1(this.get_uid());
                        throw new SystemException("Participant failed to complete");
                    }
                    absRec = iter.iterate();
                }
            }
        } else {
            throw new WrongStateException();
        }
    }

    public int close() throws SystemException {
        try {
            this.complete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.end(true);
    }

    public int cancel() {
        return super.cancel();
    }

    public void enlistParticipant(Participant act) throws WrongStateException, DuplicateParticipantException, InvalidParticipantException, SystemException {
        if (act == null) {
            throw new InvalidParticipantException();
        }
        ParticipantRecord rec = new ParticipantRecord(act, new Uid());
        if (this.add(rec) != 2) {
            throw new WrongStateException();
        }
    }

    public synchronized void delistParticipant(String participantId) throws InvalidParticipantException, WrongStateException, SystemException {
        if (participantId == null) {
            throw new SystemException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_2());
        }
        int status = this.status();
        switch (status) {
            case 0: 
            case 3: {
                this.changeParticipantStatus(participantId, 0);
                break;
            }
            default: {
                throw new WrongStateException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_3());
            }
        }
    }

    public synchronized void participantCompleted(String participantId) throws InvalidParticipantException, WrongStateException, SystemException {
        if (participantId == null) {
            throw new SystemException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_2());
        }
        int status = this.status();
        switch (status) {
            case 4: {
                break;
            }
            case 0: 
            case 3: {
                this.changeParticipantStatus(participantId, 1);
                break;
            }
            default: {
                throw new WrongStateException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_3());
            }
        }
    }

    public synchronized void participantFaulted(String participantId) throws InvalidParticipantException, SystemException {
        if (participantId == null) {
            throw new SystemException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_2());
        }
        int status = this.status();
        switch (status) {
            case 0: {
                this.preventCommit();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                this.changeParticipantStatus(participantId, 2);
                break;
            }
            default: {
                throw new SystemException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_3());
            }
        }
    }

    public synchronized void participantCannotComplete(String participantId) throws InvalidParticipantException, WrongStateException, SystemException {
        if (participantId == null) {
            throw new SystemException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_2());
        }
        int status = this.status();
        switch (status) {
            case 0: {
                this.preventCommit();
            }
            case 3: {
                this.changeParticipantStatus(participantId, 0);
                break;
            }
            default: {
                throw new WrongStateException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_3());
            }
        }
    }

    public void enlistSynchronization(Synchronization act) throws WrongStateException, DuplicateSynchronizationException, InvalidSynchronizationException, SystemException {
        if (act == null) {
            throw new InvalidSynchronizationException();
        }
        SynchronizationRecord rec = new SynchronizationRecord(act, new Uid());
        if (this.addSynchronization(rec) != 2) {
            throw new WrongStateException();
        }
    }

    public void delistSynchronization(Synchronization act) throws InvalidSynchronizationException, WrongStateException, SystemException {
        if (act == null) {
            throw new InvalidSynchronizationException();
        }
        throw new WrongStateException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_BACoordinator_4());
    }

    public Qualifier[] qualifiers() throws SystemException {
        return null;
    }

    public CoordinatorId identifier() throws SystemException {
        return this._theId;
    }

    public String type() {
        return "/StateManager/BasicAction/AtomicAction/Sagas/BACoordinator";
    }

    private final void changeParticipantStatus(String participantId, int status) throws InvalidParticipantException, SystemException {
        boolean found = false;
        if (this.pendingList != null) {
            RecordListIterator iter = new RecordListIterator(this.pendingList);
            AbstractRecord absRec = iter.iterate();
            try {
                while (absRec != null && !found) {
                    ParticipantRecord pr;
                    Participant participant;
                    if (absRec instanceof ParticipantRecord && participantId.equals((participant = (Participant)(pr = (ParticipantRecord)absRec).value()).id())) {
                        found = true;
                        if (status == 0) {
                            pr.delist(false);
                        } else if (status == 2) {
                            pr.delist(true);
                        } else {
                            pr.completed();
                        }
                    }
                    absRec = iter.iterate();
                }
            }
            catch (Exception ex) {
                throw new SystemException(ex.toString());
            }
        }
        if (!found) {
            throw new InvalidParticipantException();
        }
    }
}

