/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.security.Principal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.cxf.sts.request.Renewing;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.w3c.dom.Element;

public final class CacheUtils {
    private CacheUtils() {
    }

    public static SecurityToken createSecurityTokenForStorage(Element token, String tokenIdentifier, Date expiry, Principal principal, String realm, Renewing renewing) {
        SecurityToken securityToken = new SecurityToken(tokenIdentifier, null, expiry);
        securityToken.setToken(token);
        securityToken.setPrincipal(principal);
        HashMap<String, String> props = new HashMap<String, String>();
        securityToken.setProperties(props);
        if (realm != null) {
            props.put("org.apache.cxf.sts.token.realm", realm);
        }
        if (renewing != null) {
            props.put("org.apache.cxf.sts.token.renewing.allow", String.valueOf(renewing.isAllowRenewing()));
            props.put("org.apache.cxf.sts.token.renewing.allow.after.expiry", String.valueOf(renewing.isAllowRenewingAfterExpiry()));
        } else {
            props.put("org.apache.cxf.sts.token.renewing.allow", "true");
            props.put("org.apache.cxf.sts.token.renewing.allow.after.expiry", "false");
        }
        return securityToken;
    }

    public static void storeTokenInCache(SecurityToken securityToken, TokenStore cache, byte[] signatureValue) {
        int hash = Arrays.hashCode(signatureValue);
        securityToken.setTokenHash(hash);
        String identifier = Integer.toString(hash);
        cache.add(identifier, securityToken);
    }
}

