/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.AlternativeAttributeCheckHandler;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryService;

public class PooledConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final PooledConnectionFactoryAdd INSTANCE = new PooledConnectionFactoryAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AlternativeAttributeCheckHandler.checkAlternatives(operation, ConnectionFactoryAttributes.Common.CONNECTORS.getName(), ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName(), false);
        for (AttributeDefinition attribute : ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES)) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String txType;
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        ModelNode resolvedModel = model.clone();
        for (AttributeDefinition attribute : ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES)) {
            resolvedModel.get(attribute.getName()).set(attribute.resolveModelAttribute(context, resolvedModel));
        }
        ArrayList<String> jndiNames = new ArrayList<String>();
        for (ModelNode node : resolvedModel.get(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList()) {
            jndiNames.add(node.asString());
        }
        String managedConnectionPoolClassName = null;
        if (resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName())) {
            managedConnectionPoolClassName = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()).asString();
        }
        int minPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).asInt();
        int maxPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).asInt();
        Boolean enlistmentTrace = null;
        if (resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName())) {
            enlistmentTrace = resolvedModel.get(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName()).asBoolean();
        }
        String txSupport = resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()) ? ("local".equals(txType = resolvedModel.get(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()).asString()) ? "LocalTransaction" : ("none".equals(txType) ? "NoTransaction" : "XATransaction")) : "XATransaction";
        ServiceTarget serviceTarget = context.getServiceTarget();
        List connectors = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        String discoveryGroupName = PooledConnectionFactoryAdd.getDiscoveryGroup(resolvedModel);
        String jgroupsChannelName = null;
        if (discoveryGroupName != null) {
            Resource dgResource = context.readResourceFromRoot(MessagingServices.getActiveMQServerPathAddress(address).append("discovery-group", discoveryGroupName));
            ModelNode dgModel = dgResource.getModel();
            jgroupsChannelName = CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, dgModel).asString();
        }
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(resolvedModel, context);
        PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(address);
        PooledConnectionFactoryService.installService(serviceTarget, name, serverAddress.getLastElement().getValue(), connectors, discoveryGroupName, jgroupsChannelName, adapterParams, jndiNames, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace);
    }

    static String getDiscoveryGroup(ModelNode model) {
        if (model.hasDefined(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName())) {
            return model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()).asString();
        }
        return null;
    }

    static List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model, OperationContext context) throws OperationFailedException {
        ArrayList<PooledConnectionFactoryConfigProperties> configs = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (ConnectionFactoryAttribute nodeAttribute : PooledConnectionFactoryDefinition.ATTRIBUTES) {
            AttributeDefinition definition;
            ModelNode node;
            if (!nodeAttribute.isResourceAdapterProperty() || !(node = (definition = nodeAttribute.getDefinition()).resolveModelAttribute(context, model)).isDefined()) continue;
            String value = node.asString();
            configs.add(new PooledConnectionFactoryConfigProperties(nodeAttribute.getPropertyName(), value, nodeAttribute.getClassType()));
        }
        return configs;
    }
}

