/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.cosnaming;

import com.sun.corba.se.impl.logging.NamingSystemException;
import com.sun.corba.se.impl.naming.cosnaming.InternalBindingKey;
import com.sun.corba.se.impl.naming.cosnaming.InternalBindingValue;
import com.sun.corba.se.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.se.impl.naming.cosnaming.NamingContextImpl;
import com.sun.corba.se.impl.naming.cosnaming.TransientBindingIterator;
import com.sun.corba.se.spi.orb.ORB;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;

public class TransientNamingContext
extends NamingContextImpl
implements NamingContextDataStore {
    private Logger readLogger;
    private Logger updateLogger;
    private Logger lifecycleLogger;
    private NamingSystemException wrapper;
    private final Hashtable theHashtable = new Hashtable();
    public Object localRoot;

    public TransientNamingContext(ORB orb, Object initial, POA nsPOA) throws Exception {
        super(orb, nsPOA);
        this.wrapper = NamingSystemException.get(orb, "naming");
        this.localRoot = initial;
        this.readLogger = orb.getLogger("naming.read");
        this.updateLogger = orb.getLogger("naming.update");
        this.lifecycleLogger = orb.getLogger("naming.lifecycle");
        this.lifecycleLogger.fine("Root TransientNamingContext LIFECYCLE.CREATED");
    }

    @Override
    public final void Bind(NameComponent n, Object obj, BindingType bt) throws SystemException {
        InternalBindingKey key = new InternalBindingKey(n);
        NameComponent[] name = new NameComponent[]{n};
        Binding b = new Binding(name, bt);
        InternalBindingValue value = new InternalBindingValue(b, null);
        value.theObjectRef = obj;
        InternalBindingValue oldValue = this.theHashtable.put(key, value);
        if (oldValue != null) {
            this.updateLogger.warning("<<NAMING BIND>>Name " + this.getName(n) + " Was Already Bound");
            throw this.wrapper.transNcBindAlreadyBound();
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>>Name Component: " + n.id + "." + n.kind);
        }
    }

    @Override
    public final Object Resolve(NameComponent n, BindingTypeHolder bth) throws SystemException {
        if (n.id.length() == 0 && n.kind.length() == 0) {
            bth.value = BindingType.ncontext;
            return this.localRoot;
        }
        InternalBindingKey key = new InternalBindingKey(n);
        InternalBindingValue value = (InternalBindingValue)this.theHashtable.get(key);
        if (value == null) {
            return null;
        }
        if (this.readLogger.isLoggable(Level.FINE)) {
            this.readLogger.fine("<<NAMING RESOLVE>><<SUCCESS>>Namecomponent :" + this.getName(n));
        }
        bth.value = value.theBinding.binding_type;
        return value.theObjectRef;
    }

    @Override
    public final Object Unbind(NameComponent n) throws SystemException {
        InternalBindingKey key = new InternalBindingKey(n);
        InternalBindingValue value = (InternalBindingValue)this.theHashtable.remove(key);
        if (value == null) {
            if (this.updateLogger.isLoggable(Level.FINE)) {
                this.updateLogger.fine("<<NAMING UNBIND>><<FAILURE>> There was no binding with the name " + this.getName(n) + " to Unbind ");
            }
            return null;
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING UNBIND>><<SUCCESS>> NameComponent:  " + this.getName(n));
        }
        return value.theObjectRef;
    }

    @Override
    public final void List(int how_many, BindingListHolder bl, BindingIteratorHolder bi) throws SystemException {
        try {
            BindingIterator bindingRef;
            TransientBindingIterator bindingIterator = new TransientBindingIterator(this.orb, (Hashtable)this.theHashtable.clone(), this.nsPOA);
            bindingIterator.list(how_many, bl);
            byte[] objectId = this.nsPOA.activate_object(bindingIterator);
            Object obj = this.nsPOA.id_to_reference(objectId);
            bi.value = bindingRef = BindingIteratorHelper.narrow(obj);
        }
        catch (SystemException e) {
            this.readLogger.warning("<<NAMING LIST>><<FAILURE>>" + e);
            throw e;
        }
        catch (Exception e) {
            this.readLogger.severe("<<NAMING LIST>><<FAILURE>>" + e);
            throw this.wrapper.transNcListGotExc(e);
        }
    }

    @Override
    public final NamingContext NewContext() throws SystemException {
        try {
            TransientNamingContext transContext = new TransientNamingContext(this.orb, this.localRoot, this.nsPOA);
            byte[] objectId = this.nsPOA.activate_object(transContext);
            Object obj = this.nsPOA.id_to_reference(objectId);
            this.lifecycleLogger.fine("TransientNamingContext LIFECYCLE.CREATE SUCCESSFUL");
            return NamingContextHelper.narrow(obj);
        }
        catch (SystemException e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE CREATE>><<FAILURE>>", e);
            throw e;
        }
        catch (Exception e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE CREATE>><<FAILURE>>", e);
            throw this.wrapper.transNcNewctxGotExc(e);
        }
    }

    @Override
    public final void Destroy() throws SystemException {
        try {
            byte[] objectId = this.nsPOA.servant_to_id(this);
            if (objectId != null) {
                this.nsPOA.deactivate_object(objectId);
            }
            if (this.lifecycleLogger.isLoggable(Level.FINE)) {
                this.lifecycleLogger.fine("<<LIFECYCLE DESTROY>><<SUCCESS>>");
            }
        }
        catch (SystemException e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE DESTROY>><<FAILURE>>", e);
            throw e;
        }
        catch (Exception e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE DESTROY>><<FAILURE>>", e);
            throw this.wrapper.transNcDestroyGotExc(e);
        }
    }

    private String getName(NameComponent n) {
        return n.id + "." + n.kind;
    }

    @Override
    public final boolean IsEmpty() {
        return this.theHashtable.isEmpty();
    }
}

