/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.AsyncFutureTask;

public class ServerBootOperationsService
implements Service<Void> {
    final InjectedValue<ModelController> serverController = new InjectedValue();
    final InjectedValue<HostControllerClient> clientInjector = new InjectedValue();
    final InjectedValue<Executor> executorInjector = new InjectedValue();
    private FutureBootUpdates future = new FutureBootUpdates();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        final HostControllerClient client = (HostControllerClient)this.clientInjector.getValue();
        final ModelController controller = (ModelController)this.serverController.getValue();
        Executor executor = (Executor)this.executorInjector.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    client.resolveBootUpdates(controller, ServerBootOperationsService.this.future);
                    context.complete();
                }
                catch (Exception e) {
                    ServerBootOperationsService.this.future.failed(e);
                    context.failed(new StartException((Throwable)e));
                }
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized void stop(StopContext context) {
        FutureBootUpdates updates = this.future;
        this.future = new FutureBootUpdates();
        if (!updates.isDone()) {
            updates.cancelled();
        }
    }

    public Future<ModelNode> getFutureResult() {
        return new Future<ModelNode>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return ServerBootOperationsService.this.getFutureTask().cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return ServerBootOperationsService.this.getFutureTask().isCancelled();
            }

            @Override
            public boolean isDone() {
                return ServerBootOperationsService.this.getFutureTask().isDone();
            }

            @Override
            public ModelNode get() throws InterruptedException, ExecutionException {
                return (ModelNode)ServerBootOperationsService.this.getFutureTask().get();
            }

            @Override
            public ModelNode get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (ModelNode)ServerBootOperationsService.this.getFutureTask().get(timeout, unit);
            }
        };
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    private synchronized Future<ModelNode> getFutureTask() {
        return this.future;
    }

    public InjectedValue<HostControllerClient> getClientInjector() {
        return this.clientInjector;
    }

    public InjectedValue<ModelController> getServerController() {
        return this.serverController;
    }

    public InjectedValue<Executor> getExecutorInjector() {
        return this.executorInjector;
    }

    private static class FutureBootUpdates
    extends AsyncFutureTask<ModelNode>
    implements ActiveOperation.CompletedCallback<ModelNode> {
        private FutureBootUpdates() {
            super(null);
        }

        public void completed(ModelNode result) {
            this.setResult(result);
        }

        public void failed(Exception e) {
            this.setFailed(e);
        }

        public void cancelled() {
            this.setCancelled();
        }
    }
}

