/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.outbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.transaction.Transaction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.jboss.jbossts.txbridge.outbound.BridgeSynchronization;
import org.jboss.jbossts.txbridge.outbound.BridgeXAResource;
import org.jboss.jbossts.txbridge.outbound.OutboundBridge;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;
import org.jboss.jbossts.xts.bridge.at.BridgeWrapper;

public class OutboundBridgeManager {
    public static String BRIDGEWRAPPER_PREFIX = "txbridge_";
    private static final ConcurrentMap<Uid, OutboundBridge> outboundBridgeMappings = new ConcurrentHashMap<Uid, OutboundBridge>();

    public static OutboundBridge getOutboundBridge() {
        txbridgeLogger.logger.trace((Object)"OutboundBridgeManager.getOutboundBridge()");
        try {
            Transaction transaction = (Transaction)TransactionManager.transactionManager().getTransaction();
            Uid externalTxId = transaction.get_uid();
            if (!outboundBridgeMappings.containsKey(externalTxId)) {
                OutboundBridgeManager.createMapping(transaction, externalTxId);
            }
            return (OutboundBridge)outboundBridgeMappings.get(externalTxId);
        }
        catch (SystemException e) {
            txbridgeLogger.logger.error((Object)e);
            return null;
        }
    }

    public static synchronized void removeMapping(Uid externalTxId) {
        txbridgeLogger.logger.trace((Object)("OutboundBridgeManager.removeMapping(externalTxId=" + externalTxId + ")"));
        if (externalTxId != null) {
            outboundBridgeMappings.remove(externalTxId);
        }
    }

    private static synchronized void createMapping(Transaction transaction, Uid externalTxId) throws SystemException {
        txbridgeLogger.logger.trace((Object)("OutboundBridgeManager.createmapping(externalTxId=" + externalTxId + ")"));
        if (outboundBridgeMappings.containsKey(externalTxId)) {
            return;
        }
        BridgeWrapper bridgeWrapper = BridgeWrapper.create((String)BRIDGEWRAPPER_PREFIX, (long)0L, (boolean)false);
        OutboundBridge outboundBridge = new OutboundBridge(bridgeWrapper);
        BridgeXAResource xaResource = new BridgeXAResource(externalTxId, bridgeWrapper);
        BridgeSynchronization synchronization = new BridgeSynchronization(bridgeWrapper);
        try {
            transaction.enlistResource((XAResource)xaResource);
            transaction.registerSynchronization((Synchronization)synchronization);
        }
        catch (RollbackException e) {
            txbridgeLogger.i18NLogger.error_obm_unabletoenlist(e);
            throw new SystemException(e.toString());
        }
        outboundBridgeMappings.put(externalTxId, outboundBridge);
    }
}

