/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.File;
import java.io.IOException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.vfs.VirtualFile;

@MessageBundle(projectCode="VFS")
public interface VFSMessages {
    public static final VFSMessages MESSAGES = Messages.getBundle(VFSMessages.class);

    @Message(id=10, value="Can't set up temp file provider")
    public RuntimeException cantSetupTempFileProvider(@Cause Throwable var1);

    @Message(id=11, value="Temp directory closed")
    public IOException tempDirectoryClosed();

    @Message(id=12, value="Temp file provider closed")
    public IOException tempFileProviderClosed();

    @Message(id=14, value="Could not create directory for root '%s' (prefix '%s', suffix '%s') after %d attempts")
    public IOException couldNotCreateDirectoryForRoot(File var1, String var2, String var3, int var4);

    @Message(id=15, value="Could not create directory for original name '%s' after %d attempts")
    public IOException couldNotCreateDirectory(String var1, int var2);

    @Message(id=16, value="Root filesystem already mounted")
    public IOException rootFileSystemAlreadyMounted();

    @Message(id=17, value="Filesystem already mounted at mount point \"%s\"")
    public IOException fileSystemAlreadyMountedAtMountPoint(VirtualFile var1);

    @Message(id=18, value="Stream is closed")
    public IOException streamIsClosed();

    @Message(id=19, value="Not a file: '%s'")
    public IOException notAFile(String var1);

    @Message(id=20, value="Remote host access not supported for URLs of type '%s'")
    public IOException remoteHostAccessNotSupportedForUrls(String var1);

    @Message(id=21, value="%s must not be null")
    public IllegalArgumentException nullArgument(String var1);

    @Message(id=22, value="Null or empty %s")
    public IllegalArgumentException nullOrEmpty(String var1);

    @Message(id=23, value="Given parent (%s) is not an ancestor of this virtual file")
    public IllegalArgumentException parentIsNotAncestor(VirtualFile var1);

    @Message(id=24, value="Problems creating new directory: %s")
    public IllegalArgumentException problemCreatingNewDirectory(VirtualFile var1);

    @Message(id=25, value="Invalid Win32 path: %s")
    public IllegalArgumentException invalidWin32Path(String var1);

    @Message(id=26, value="Cannot decode: %s [%s]")
    public IllegalArgumentException cannotDecode(String var1, String var2, @Cause Exception var3);

    @Message(id=27, value="Invalid jar signature %s should be %s")
    public IOException invalidJarSignature(String var1, String var2);

    @Message(id=28, value="Invalid actions string: %s")
    public IllegalArgumentException invalidActionsString(String var1);

    @Message(id=29, value="The totalBufferLength must be larger than: %s")
    public IllegalArgumentException bufferMustBeLargerThan(int var1);

    @Message(id=30, value="Buffer does not have enough capacity")
    public IllegalArgumentException bufferDoesntHaveEnoughCapacity();

    @Message(id=31, value="The preconfigured attributes are immutable")
    public IllegalStateException preconfiguredAttributesAreImmutable();

    @Message(id=32, value=".. on root path")
    public IllegalStateException onRootPath();
}

