/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.security;

import java.security.Permission;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules._private.ModulesPrivateAccess;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.modules.security.UninitializedPermission;

public final class ModularPermissionFactory
implements PermissionFactory {
    private final ModuleLoader moduleLoader;
    private final ModuleIdentifier moduleIdentifier;
    private final String className;
    private final String targetName;
    private final String permissionActions;
    private volatile Permission instance = UninitializedPermission.INSTANCE;
    private static final ModulesPrivateAccess access = Module.getPrivateAccess();

    public ModularPermissionFactory(ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, String className, String targetName, String permissionActions) {
        if (moduleLoader == null) {
            throw new IllegalArgumentException("moduleLoader is null");
        }
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("moduleIdentifier is null");
        }
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        this.moduleLoader = moduleLoader;
        this.moduleIdentifier = moduleIdentifier;
        this.className = className;
        this.targetName = targetName;
        this.permissionActions = permissionActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Permission construct() {
        if (this.instance != UninitializedPermission.INSTANCE) {
            return this.instance;
        }
        ModularPermissionFactory modularPermissionFactory = this;
        synchronized (modularPermissionFactory) {
            if (this.instance != UninitializedPermission.INSTANCE) {
                return this.instance;
            }
            try {
                Module module = this.moduleLoader.loadModule(this.moduleIdentifier);
                Class<Permission> permissionClass = access.getClassLoaderOf(module).loadClass(this.className, true).asSubclass(Permission.class);
                this.instance = PermissionFactory.constructFromClass(permissionClass, this.targetName, this.permissionActions);
                return this.instance;
            }
            catch (Throwable t) {
                this.instance = null;
                return null;
            }
        }
    }
}

