/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=KeyValueWithPreviousExternalizer.class)
public class KeyValueWithPrevious<K, V> {
    private static final long serialVersionUID = -7875910676423622104L;
    private final K key;
    private final V value;
    private final V prev;

    public KeyValueWithPrevious(K key, V value, V prev) {
        this.key = key;
        this.value = value;
        this.prev = prev;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public V getPrev() {
        return this.prev;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueWithPrevious keyValueWithPrevious = (KeyValueWithPrevious)o;
        if (this.key != null ? !this.key.equals(keyValueWithPrevious.key) : keyValueWithPrevious.key != null) {
            return false;
        }
        if (this.prev != null ? !this.prev.equals(keyValueWithPrevious.prev) : keyValueWithPrevious.prev != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(keyValueWithPrevious.value) : keyValueWithPrevious.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.prev != null ? this.prev.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "KeyValueWithPrevious{key=" + this.key + ", value=" + this.value + ", prev=" + this.prev + '}';
    }

    public static class KeyValueWithPreviousExternalizer
    implements Externalizer<KeyValueWithPrevious> {
        @Override
        public void writeObject(ObjectOutput output, KeyValueWithPrevious kvPair) throws IOException {
            output.writeObject(kvPair.getKey());
            output.writeObject(kvPair.getValue());
            output.writeObject(kvPair.getPrev());
        }

        @Override
        public KeyValueWithPrevious readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new KeyValueWithPrevious<Object, Object>(input.readObject(), input.readObject(), input.readObject());
        }
    }
}

