/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.InVMTransportConfigurationSchema;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class InVMServerLocatorSchema
extends AbstractServerLocatorSchema {
    public String getSchemaName() {
        return "vm";
    }

    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        TransportConfiguration tc = InVMTransportConfigurationSchema.createTransportConfiguration(uri, query, name, "org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory");
        ServerLocator factory = ActiveMQClient.createServerLocatorWithoutHA(tc);
        return (ServerLocator)URISchema.setData((URI)uri, (Object)factory, query);
    }

    protected URI internalNewURI(ServerLocator bean) throws Exception {
        return InVMServerLocatorSchema.getUri(bean.getStaticTransportConfigurations());
    }

    public static URI getUri(TransportConfiguration[] configurations) throws URISyntaxException {
        String host = "0";
        if (configurations != null && configurations.length > 0) {
            TransportConfiguration configuration = configurations[0];
            Map<String, Object> params = configuration.getParams();
            host = params.get("serverId") == null ? host : params.get("serverId").toString();
        }
        return new URI("vm", null, host, -1, null, null, null);
    }
}

