/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.module;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.cli.handlers.module.ModuleConfig;
import org.jboss.as.cli.handlers.module.ModuleDependency;
import org.jboss.as.cli.handlers.module.ResourceRoot;
import org.jboss.staxmapper.FormattingXMLStreamWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ModuleConfigImpl
implements ModuleConfig {
    static final String DEPENDENCIES = "dependencies";
    static final String MAIN_CLASS = "main-class";
    static final String MODULE = "module";
    static final String MODULE_NS = "urn:jboss:module:1.1";
    static final String NAME = "name";
    static final String SLOT = "slot";
    static final String PATH = "path";
    static final String PROPERTY = "property";
    static final String PROPERTIES = "properties";
    static final String RESOURCES = "resources";
    static final String RESOURCE_ROOT = "resource-root";
    static final String VALUE = "value";
    private String schemaVersion = "urn:jboss:module:1.1";
    private String moduleName;
    private String mainClass;
    private String slotName;
    private Collection<ModuleConfig.Resource> resources;
    private Collection<ModuleConfig.Dependency> dependencies;
    private Map<String, String> properties;
    private static final char[] NEW_LINE = new char[]{'\n'};

    public ModuleConfigImpl(String moduleName) {
        if (moduleName == null || moduleName.isEmpty()) {
            throw new IllegalArgumentException("Module name can't be null");
        }
        this.moduleName = moduleName;
    }

    @Override
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getSlot() {
        return this.slotName;
    }

    public void setSlot(String slot) {
        this.slotName = slot;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public Collection<ModuleConfig.Resource> getResources() {
        return this.resources == null ? Collections.emptyList() : this.resources;
    }

    public void addResource(ModuleConfig.Resource res) {
        if (res == null) {
            throw new IllegalArgumentException("Resource cannot be null.");
        }
        if (this.resources == null) {
            this.resources = new ArrayList<ModuleConfig.Resource>();
        }
        this.resources.add(res);
    }

    @Override
    public Collection<ModuleConfig.Dependency> getDependencies() {
        return this.dependencies == null ? Collections.emptyList() : this.dependencies;
    }

    public void addDependency(ModuleConfig.Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency cannot be null.");
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ModuleConfig.Dependency>();
        }
        this.dependencies.add(dep);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.emptyMap() : this.properties;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name can't be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Property value can't be null.");
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModuleConfig value) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement(MODULE);
        writer.writeDefaultNamespace(MODULE_NS);
        if (this.moduleName == null) {
            throw new XMLStreamException("Module name is missing.");
        }
        writer.writeAttribute(NAME, this.moduleName);
        if (this.slotName != null) {
            writer.writeAttribute(SLOT, this.slotName);
        }
        if (this.properties != null) {
            ModuleConfigImpl.writeNewLine(writer);
            writer.writeStartElement(PROPERTIES);
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                writer.writeStartElement(PROPERTY);
                writer.writeAttribute(NAME, entry.getKey());
                writer.writeAttribute(VALUE, entry.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.mainClass != null) {
            ModuleConfigImpl.writeNewLine(writer);
            writer.writeStartElement(MAIN_CLASS);
            writer.writeAttribute(NAME, this.mainClass);
            writer.writeEndElement();
        }
        if (this.resources != null) {
            ModuleConfigImpl.writeNewLine(writer);
            writer.writeStartElement(RESOURCES);
            for (ModuleConfig.Resource res : this.resources) {
                res.writeContent(writer, res);
            }
            writer.writeEndElement();
        }
        if (this.dependencies != null) {
            ModuleConfigImpl.writeNewLine(writer);
            writer.writeStartElement(DEPENDENCIES);
            for (ModuleConfig.Dependency dep : this.dependencies) {
                dep.writeContent(writer, dep);
            }
            writer.writeEndElement();
        }
        ModuleConfigImpl.writeNewLine(writer);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    protected static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(NEW_LINE, 0, 1);
    }

    public static void main(String[] args) throws Exception {
        ModuleConfigImpl module = new ModuleConfigImpl("o.r.g");
        module.setProperty("jboss.api", "private");
        module.setProperty("prop", VALUE);
        module.setMainClass("o.r.g.MainClass");
        module.addResource(new ResourceRoot("a.jar"));
        module.addResource(new ResourceRoot("another.jar"));
        module.addDependency(new ModuleDependency("a.module"));
        module.addDependency(new ModuleDependency("another.module"));
        StringWriter strWriter = new StringWriter();
        XMLExtendedStreamWriter writer = ModuleConfigImpl.create(XMLOutputFactory.newInstance().createXMLStreamWriter(strWriter));
        module.writeContent(writer, module);
        writer.flush();
        System.out.println(strWriter.toString());
    }

    public static XMLExtendedStreamWriter create(XMLStreamWriter writer) throws Exception {
        return new FormattingXMLStreamWriter(writer);
    }
}

