/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.impl.AndDocIdSet;

public class ChainedFilter
extends Filter {
    private final List<Filter> chainedFilters = new ArrayList<Filter>();

    public void addFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The specified filter cannot be null");
        }
        this.chainedFilters.add(filter);
    }

    public boolean removeFilter(Filter filter) {
        return this.chainedFilters.remove(filter);
    }

    public boolean isEmpty() {
        return this.chainedFilters.size() == 0;
    }

    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        int size = this.chainedFilters.size();
        if (size == 0) {
            throw new AssertionFailure("No filters to chain");
        }
        if (size == 1) {
            return this.chainedFilters.get(0).getDocIdSet(context, acceptDocs);
        }
        ArrayList<DocIdSet> subSets = new ArrayList<DocIdSet>(size);
        for (Filter f : this.chainedFilters) {
            subSets.add(f.getDocIdSet(context, acceptDocs));
        }
        LeafReader reader = context.reader();
        return new AndDocIdSet(subSets, reader.maxDoc());
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("ChainedFilter{chainedFilters=");
        for (Filter filter : this.chainedFilters) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(filter.toString(field));
        }
        sb.append('}');
        return sb.toString();
    }
}

