/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditManager;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;

public class ClientProducerCreditManagerImpl
implements ClientProducerCreditManager {
    public static final int MAX_UNREFERENCED_CREDITS_CACHE_SIZE = 1000;
    private final Map<SimpleString, ClientProducerCredits> producerCredits = new LinkedHashMap<SimpleString, ClientProducerCredits>();
    private final Map<SimpleString, ClientProducerCredits> unReferencedCredits = new LinkedHashMap<SimpleString, ClientProducerCredits>();
    private final ClientSessionInternal session;
    private int windowSize;

    public ClientProducerCreditManagerImpl(ClientSessionInternal session, int windowSize) {
        this.session = session;
        this.windowSize = windowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClientProducerCredits getCredits(SimpleString address, boolean anon, SessionContext context) {
        ClientProducerCredits credits;
        if (this.windowSize == -1) {
            return ClientProducerCreditsNoFlowControl.instance;
        }
        boolean needInit = false;
        ClientProducerCreditManagerImpl clientProducerCreditManagerImpl = this;
        synchronized (clientProducerCreditManagerImpl) {
            credits = this.producerCredits.get(address);
            if (credits == null) {
                credits = new ClientProducerCreditsImpl(this.session, address, this.windowSize);
                needInit = true;
                this.producerCredits.put(address, credits);
            }
            if (!anon) {
                credits.incrementRefCount();
                this.unReferencedCredits.remove(address);
            } else {
                this.addToUnReferencedCache(address, credits);
            }
        }
        if (needInit) {
            credits.init(context);
        }
        return credits;
    }

    @Override
    public synchronized void returnCredits(SimpleString address) {
        ClientProducerCredits credits = this.producerCredits.get(address);
        if (credits != null && credits.decrementRefCount() == 0) {
            this.addToUnReferencedCache(address, credits);
        }
    }

    @Override
    public synchronized void receiveCredits(SimpleString address, int credits) {
        ClientProducerCredits cr = this.producerCredits.get(address);
        if (cr != null) {
            cr.receiveCredits(credits);
        }
    }

    @Override
    public synchronized void receiveFailCredits(SimpleString address, int credits) {
        ClientProducerCredits cr = this.producerCredits.get(address);
        if (cr != null) {
            cr.receiveFailCredits(credits);
        }
    }

    @Override
    public synchronized void reset() {
        for (ClientProducerCredits credits : this.producerCredits.values()) {
            credits.reset();
        }
    }

    @Override
    public synchronized void close() {
        this.windowSize = -1;
        for (ClientProducerCredits credits : this.producerCredits.values()) {
            credits.close();
        }
        this.producerCredits.clear();
        this.unReferencedCredits.clear();
    }

    @Override
    public synchronized int creditsMapSize() {
        return this.producerCredits.size();
    }

    @Override
    public synchronized int unReferencedCreditsSize() {
        return this.unReferencedCredits.size();
    }

    private void addToUnReferencedCache(SimpleString address, ClientProducerCredits credits) {
        this.unReferencedCredits.put(address, credits);
        if (this.unReferencedCredits.size() > 1000) {
            Iterator<Map.Entry<SimpleString, ClientProducerCredits>> iter = this.unReferencedCredits.entrySet().iterator();
            Map.Entry<SimpleString, ClientProducerCredits> oldest = iter.next();
            iter.remove();
            this.removeEntry(oldest.getKey(), oldest.getValue());
        }
    }

    private void removeEntry(SimpleString address, ClientProducerCredits credits) {
        this.producerCredits.remove(address);
        credits.releaseOutstanding();
        credits.close();
    }

    static class ClientProducerCreditsNoFlowControl
    implements ClientProducerCredits {
        static ClientProducerCreditsNoFlowControl instance = new ClientProducerCreditsNoFlowControl();

        ClientProducerCreditsNoFlowControl() {
        }

        @Override
        public void acquireCredits(int credits) throws InterruptedException {
        }

        @Override
        public void receiveCredits(int credits) {
        }

        @Override
        public void receiveFailCredits(int credits) {
        }

        @Override
        public boolean isBlocked() {
            return false;
        }

        @Override
        public void init(SessionContext ctx) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void close() {
        }

        @Override
        public void incrementRefCount() {
        }

        @Override
        public int decrementRefCount() {
            return 1;
        }

        @Override
        public void releaseOutstanding() {
        }
    }
}

