/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.dmr.ModelNode;

public interface PatchingHistory {
    public ModelNode getHistory() throws PatchingException;

    public ModelNode getHistory(PatchableTarget.TargetInfo var1) throws PatchingException;

    public Iterator iterator() throws PatchingException;

    public Iterator iterator(PatchableTarget.TargetInfo var1) throws PatchingException;

    public static class Factory {
        private Factory() {
        }

        public static ModelNode getHistory(InstalledIdentity installedImage, PatchableTarget.TargetInfo info) throws PatchingException {
            ModelNode result = new ModelNode();
            result.setEmptyList();
            Factory.fillHistoryIn(installedImage, info, result);
            return result;
        }

        public static Iterator iterator(InstalledIdentity mgr, PatchableTarget.TargetInfo info) {
            if (info == null) {
                throw new IllegalArgumentException("target info is null");
            }
            return new IteratorImpl(info, mgr);
        }

        public static PatchingHistory getHistory(final InstalledIdentity installedIdentity) {
            if (installedIdentity == null) {
                throw new IllegalStateException("installedImage is null");
            }
            return new PatchingHistory(){

                @Override
                public ModelNode getHistory() throws PatchingException {
                    try {
                        return this.getHistory(installedIdentity.getIdentity().loadTargetInfo());
                    }
                    catch (IOException e) {
                        throw new PatchingException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()), e);
                    }
                }

                @Override
                public ModelNode getHistory(PatchableTarget.TargetInfo info) throws PatchingException {
                    return Factory.getHistory(installedIdentity, info);
                }

                @Override
                public Iterator iterator() throws PatchingException {
                    try {
                        return this.iterator(installedIdentity.getIdentity().loadTargetInfo());
                    }
                    catch (IOException e) {
                        throw new PatchingException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()), e);
                    }
                }

                @Override
                public Iterator iterator(PatchableTarget.TargetInfo info) throws PatchingException {
                    return Factory.iterator(installedIdentity, info);
                }
            };
        }

        private static void fillHistoryIn(InstalledIdentity installedImage, PatchableTarget.TargetInfo info, ModelNode result) throws PatchingException {
            Iterator i = Factory.iterator(installedImage, info);
            while (i.hasNext()) {
                Entry next = (Entry)i.next();
                Factory.fillHistoryIn(result, next.getType(), next.getPatchId(), next.getAppliedAt());
            }
        }

        private static void fillHistoryIn(ModelNode result, Patch.PatchType type, String patchID, String appliedAt) throws PatchingException {
            ModelNode history = new ModelNode();
            history.get("patch-id").set(patchID);
            history.get("type").set(type.getName());
            ModelNode appliedAtNode = history.get("applied-at");
            if (appliedAt != null) {
                appliedAtNode.set(appliedAt);
            }
            result.add(history);
        }

        private static final class IteratorImpl
        extends IteratorState
        implements Iterator {
            private final InstalledIdentity mgr;

            private IteratorImpl(InstalledIdentity mgr) throws PatchingException {
                super(mgr);
                this.mgr = mgr;
            }

            private IteratorImpl(PatchableTarget.TargetInfo info, InstalledIdentity mgr) {
                super(info);
                this.mgr = mgr;
            }

            @Override
            public boolean hasNext() {
                return IteratorImpl.hasNext(this.mgr, this);
            }

            private static boolean hasNext(InstalledIdentity installedIdentity, IteratorState state) {
                File rollbackXml;
                if (state.patchIndex < 0) {
                    return !"base".equals(state.currentInfo.getCumulativePatchID()) || !state.currentInfo.getPatchIDs().isEmpty();
                }
                int size = state.currentInfo.getPatchIDs().size();
                if (state.patchIndex < size) {
                    return IteratorImpl.existsOnDisk(installedIdentity, state.currentInfo.getPatchIDs().get(state.patchIndex));
                }
                String releaseID = state.currentInfo.getCumulativePatchID();
                if ("base".equals(releaseID)) {
                    return false;
                }
                if (state.patchIndex == size) {
                    return IteratorImpl.existsOnDisk(installedIdentity, state.currentInfo.getCumulativePatchID());
                }
                File patchHistoryDir = installedIdentity.getInstalledImage().getPatchHistoryDir(releaseID);
                if (patchHistoryDir.exists() && (rollbackXml = new File(patchHistoryDir, "rollback.xml")).exists()) {
                    try {
                        PatchBuilder patchBuilder = (PatchBuilder)PatchXml.parse(rollbackXml);
                        RollbackPatch patch = (RollbackPatch)patchBuilder.build();
                        PatchableTarget.TargetInfo nextInfo = patch.getIdentityState().getIdentity().loadTargetInfo();
                        if ("base".equals(nextInfo.getCumulativePatchID()) ? nextInfo.getPatchIDs().isEmpty() : !IteratorImpl.existsOnDisk(installedIdentity, nextInfo.getCumulativePatchID())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()), e);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public Entry next() {
                return IteratorImpl.next(this.mgr, this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static Entry next(final InstalledIdentity installedIdentity, IteratorState state) {
                String patchId = IteratorImpl.nextPatchIdForCurrentInfo(state);
                if (patchId == null) {
                    if (state.patchIndex < 0) {
                        state.patchIndex = 0;
                    } else {
                        String releaseID = state.currentInfo.getCumulativePatchID();
                        if ("base".equals(releaseID)) {
                            throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.noMorePatches());
                        }
                        File patchHistoryDir = installedIdentity.getInstalledImage().getPatchHistoryDir(releaseID);
                        if (!patchHistoryDir.exists()) throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.noPatchHistory(patchHistoryDir.getAbsolutePath()));
                        File rollbackXml = new File(patchHistoryDir, "rollback.xml");
                        if (!rollbackXml.exists()) throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.patchIsMissingFile(rollbackXml.getAbsolutePath()));
                        try {
                            PatchBuilder patchBuilder = (PatchBuilder)PatchXml.parse(rollbackXml);
                            RollbackPatch patch = (RollbackPatch)patchBuilder.build();
                            state.currentInfo = patch.getIdentityState().getIdentity().loadTargetInfo();
                            state.patchIndex = 0;
                            state.type = Patch.PatchType.ONE_OFF;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()), e);
                        }
                    }
                    patchId = IteratorImpl.nextPatchIdForCurrentInfo(state);
                    if (patchId == null) {
                        throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.noMorePatches());
                    }
                    IteratorImpl.assertExistsOnDisk(installedIdentity, patchId);
                }
                final String entryPatchId = patchId;
                final Patch.PatchType entryType = state.type;
                return new Entry(){
                    String appliedAt;
                    Map<String, String> layerPatches;
                    Map<String, String> addOnPatches;
                    Patch patch;

                    @Override
                    public String getPatchId() {
                        return entryPatchId;
                    }

                    @Override
                    public Patch.PatchType getType() {
                        return entryType;
                    }

                    @Override
                    public String getAppliedAt() {
                        File patchHistoryDir;
                        if (this.appliedAt == null && (patchHistoryDir = installedIdentity.getInstalledImage().getPatchHistoryDir(entryPatchId)).exists()) {
                            try {
                                this.appliedAt = this.getAppliedAt(patchHistoryDir);
                            }
                            catch (PatchingException patchingException) {
                                // empty catch block
                            }
                        }
                        return this.appliedAt;
                    }

                    @Override
                    public Map<String, String> getLayerPatches() {
                        if (this.layerPatches == null) {
                            this.layerPatches = this.loadLayerPatches(false);
                        }
                        return this.layerPatches;
                    }

                    @Override
                    public Map<String, String> getAddOnPatches() {
                        if (this.addOnPatches == null) {
                            this.addOnPatches = this.loadLayerPatches(true);
                        }
                        return this.addOnPatches;
                    }

                    private String getAppliedAt(File patchDir) throws PatchingException {
                        File timestampFile = new File(patchDir, "timestamp");
                        try {
                            return timestampFile.exists() ? PatchUtils.readRef(timestampFile) : null;
                        }
                        catch (IOException e) {
                            throw new PatchingException(PatchLogger.ROOT_LOGGER.fileIsNotReadable(timestampFile.getAbsolutePath()));
                        }
                    }

                    private Map<String, String> loadLayerPatches(boolean addons) {
                        Map<String, String> result = Collections.emptyMap();
                        Patch patch = this.getMetadata();
                        if (patch != null) {
                            result = new HashMap<String, String>();
                            for (PatchElement e : patch.getElements()) {
                                if (e.getProvider().isAddOn() != addons) continue;
                                result.put(e.getProvider().getName(), e.getId());
                            }
                        }
                        return result;
                    }

                    @Override
                    public Patch getMetadata() {
                        File patchXml;
                        File patchDir;
                        if (this.patch == null && (patchDir = installedIdentity.getInstalledImage().getPatchHistoryDir(entryPatchId)).exists() && (patchXml = new File(patchDir, "patch.xml")).exists()) {
                            try {
                                this.patch = ((PatchBuilder)PatchXml.parse(patchXml)).build();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        return this.patch;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private static boolean existsOnDisk(InstalledIdentity mgr, String id) {
                try {
                    IteratorImpl.assertExistsOnDisk(mgr, id);
                    return true;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            private static void assertExistsOnDisk(InstalledIdentity mgr, String id) throws NoSuchElementException {
                File historyDir = mgr.getInstalledImage().getPatchHistoryDir(id);
                if (!historyDir.exists()) {
                    throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.noPatchHistory(historyDir.getAbsolutePath()));
                }
                File rollbackXml = new File(historyDir, "rollback.xml");
                if (!rollbackXml.exists()) {
                    throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.patchIsMissingFile(rollbackXml.getAbsolutePath()));
                }
                try {
                    PatchXml.parse(rollbackXml);
                }
                catch (Exception e) {
                    throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.fileIsNotReadable(rollbackXml.getAbsolutePath() + ": " + e.getLocalizedMessage()));
                }
                File patchXml = new File(historyDir, "patch.xml");
                if (!patchXml.exists()) {
                    throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.patchIsMissingFile(patchXml.getAbsolutePath()));
                }
                try {
                    PatchXml.parse(patchXml);
                }
                catch (Exception e) {
                    throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.fileIsNotReadable(patchXml.getAbsolutePath() + ": " + e.getLocalizedMessage()));
                }
            }

            private static String nextPatchIdForCurrentInfo(IteratorState state) {
                if (state.patchIndex < 0) {
                    return null;
                }
                int size = state.currentInfo.getPatchIDs().size();
                if (state.patchIndex < size) {
                    return state.currentInfo.getPatchIDs().get(state.patchIndex++);
                }
                if (state.patchIndex == size) {
                    ++state.patchIndex;
                    state.type = Patch.PatchType.CUMULATIVE;
                    String cp = state.currentInfo.getCumulativePatchID();
                    return "base".equals(cp) ? null : cp;
                }
                return null;
            }

            @Override
            public boolean hasNextCP() {
                IteratorState state = new IteratorState(this.currentInfo, this.patchIndex);
                return IteratorImpl.nextCP(this.mgr, state) != null;
            }

            @Override
            public Entry nextCP() {
                IteratorState state = new IteratorState(this.currentInfo, this.patchIndex);
                Entry entry = IteratorImpl.nextCP(this.mgr, state);
                if (entry == null) {
                    throw new NoSuchElementException(PatchLogger.ROOT_LOGGER.noMorePatches());
                }
                this.currentInfo = state.currentInfo;
                this.patchIndex = state.patchIndex;
                this.type = state.type;
                return entry;
            }

            private static Entry nextCP(InstalledIdentity mgr, IteratorState state) {
                while (IteratorImpl.hasNext(mgr, state)) {
                    Entry entry = IteratorImpl.next(mgr, state);
                    if (state.type != Patch.PatchType.CUMULATIVE) continue;
                    return entry;
                }
                return null;
            }
        }

        private static class IteratorState {
            protected PatchableTarget.TargetInfo currentInfo;
            protected int patchIndex;
            protected Patch.PatchType type = Patch.PatchType.ONE_OFF;

            IteratorState(PatchableTarget.TargetInfo info) {
                this(info, -1);
            }

            IteratorState(PatchableTarget.TargetInfo info, int patchIndex) {
                if (info == null) {
                    throw new IllegalArgumentException("Target info is null");
                }
                this.currentInfo = info;
                this.patchIndex = patchIndex;
            }

            IteratorState(InstalledIdentity installedIdentity) throws PatchingException {
                if (installedIdentity == null) {
                    throw new IllegalArgumentException("Installation manager is null.");
                }
                try {
                    this.currentInfo = installedIdentity.getIdentity().loadTargetInfo();
                }
                catch (IOException e) {
                    throw new PatchingException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()));
                }
                this.patchIndex = -1;
            }
        }
    }

    public static interface Iterator
    extends java.util.Iterator<Entry> {
        public boolean hasNextCP();

        public Entry nextCP();
    }

    public static interface Entry {
        public String getPatchId();

        public Patch.PatchType getType();

        public String getAppliedAt();

        public Map<String, String> getLayerPatches();

        public Map<String, String> getAddOnPatches();

        public Patch getMetadata();
    }
}

