/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ListAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;

    @Deprecated
    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, elementValidator, null, null, null, false, null, null, null, null, true, (AttributeAccess.Flag[])null);
    }

    @Deprecated
    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator, AttributeAccess.Flag ... flags) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, elementValidator, null, null, null, false, null, null, null, null, true, flags);
    }

    private ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean niSignificant, AttributeParser parser, boolean allowDuplicates, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.LIST, allowNull, allowExpressions, null, null, (ParameterValidator)new ListValidator(elementValidator, allowNull, minSize, maxSize, allowDuplicates), allowNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, niSignificant, parser, flags);
        this.elementValidator = elementValidator;
    }

    protected ListAttributeDefinition(Builder<?, ?> builder) {
        super(builder);
        this.elementValidator = builder.getElementValidator();
    }

    public ParameterValidator getElementValidator() {
        return this.elementValidator;
    }

    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return SimpleAttributeDefinition.parse(this, this.elementValidator, value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    public void parseAndAddParameterElement(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, reader);
        operation.get(this.getName()).add(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        this.attributeMarshaller.marshallAsElement(this, resourceModel, marshallDefault, writer);
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        List asList;
        ModelNode result = parameter;
        try {
            asList = parameter.asList();
        }
        catch (IllegalArgumentException iae) {
            asList = null;
        }
        if (asList != null) {
            boolean changeMade = false;
            ModelNode newList = new ModelNode().setEmptyList();
            for (ModelNode item : asList) {
                ModelNode converted = this.convertParameterElementExpressions(item);
                newList.add(converted);
                changeMade |= !converted.equals(item);
            }
            if (changeMade) {
                result = newList;
            }
        }
        return result;
    }

    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        return this.isAllowExpression() ? ListAttributeDefinition.convertStringExpression(parameterElement) : parameterElement;
    }

    @Deprecated
    public void parseAndSetParameter(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        if (value != null) {
            for (String element : value.split(",")) {
                this.parseAndAddParameterElement(element.trim(), operation, reader);
            }
        }
    }

    public static abstract class Builder<BUILDER extends Builder, ATTRIBUTE extends ListAttributeDefinition>
    extends AbstractAttributeDefinitionBuilder<BUILDER, ATTRIBUTE> {
        private ParameterValidator elementValidator;
        private Boolean allowNullElement;
        private boolean allowDuplicates = true;

        protected Builder(String attributeName) {
            super(attributeName, ModelType.LIST);
        }

        protected Builder(String attributeName, boolean allowNull) {
            super(attributeName, ModelType.LIST, allowNull);
        }

        public Builder(ListAttributeDefinition basis) {
            super(basis);
            this.elementValidator = basis.getElementValidator();
        }

        public ParameterValidator getElementValidator() {
            if (this.elementValidator == null) {
                return null;
            }
            ParameterValidator toWrap = this.elementValidator;
            NillableOrExpressionParameterValidator wrappedElementValidator = null;
            if (this.elementValidator instanceof NillableOrExpressionParameterValidator) {
                NillableOrExpressionParameterValidator wrapped = (NillableOrExpressionParameterValidator)this.elementValidator;
                Boolean allow = wrapped.getAllowNull();
                if ((allow == null || allow != false) == this.getAllowNullElement() && wrapped.isAllowExpression() == this.isAllowExpression()) {
                    wrappedElementValidator = wrapped;
                } else {
                    toWrap = wrapped.getDelegate();
                }
            }
            if (wrappedElementValidator == null) {
                this.elementValidator = new NillableOrExpressionParameterValidator(toWrap, this.getAllowNullElement(), this.isAllowExpression());
            }
            return this.elementValidator;
        }

        public final BUILDER setElementValidator(ParameterValidator elementValidator) {
            if (elementValidator == null) {
                throw ControllerLogger.ROOT_LOGGER.nullVar("elementValidator");
            }
            this.elementValidator = elementValidator;
            this.validator = null;
            return (BUILDER)this;
        }

        @Override
        public BUILDER setValidator(ParameterValidator validator) {
            return this.setElementValidator(validator);
        }

        public BUILDER setListValidator(ParameterValidator validator) {
            return (BUILDER)((Builder)super.setValidator(validator));
        }

        @Override
        public int getMinSize() {
            if (this.minSize < 0) {
                this.minSize = 0;
            }
            return this.minSize;
        }

        @Override
        public int getMaxSize() {
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            return this.maxSize;
        }

        public boolean getAllowNullElement() {
            return this.allowNullElement == null ? this.isAllowNull() : this.allowNullElement.booleanValue();
        }

        public BUILDER setAllowNullElement(boolean allowNullElement) {
            this.allowNullElement = allowNullElement;
            return (BUILDER)this;
        }

        public BUILDER setAllowDuplicates(boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
            return (BUILDER)this;
        }

        @Override
        public ParameterValidator getValidator() {
            ParameterValidator result = super.getValidator();
            if (result == null) {
                ParameterValidator listElementValidator = this.getElementValidator();
                assert (listElementValidator != null);
                result = new ListValidator(this.getElementValidator(), this.isAllowNull(), this.getMinSize(), this.getMaxSize(), this.allowDuplicates);
            }
            return result;
        }
    }
}

