/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;

public class JSFMetadataProcessor
implements DeploymentUnitProcessor {
    public static final String JAVAX_FACES_WEBAPP_FACES_SERVLET = "javax.faces.webapp.FacesServlet";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null || metaData.getMergedJBossWebMetaData() == null || metaData.getMergedJBossWebMetaData().getServlets() == null) {
            return;
        }
        JBossServletMetaData jsf = null;
        for (JBossServletMetaData servlet : metaData.getMergedJBossWebMetaData().getServlets()) {
            if (!JAVAX_FACES_WEBAPP_FACES_SERVLET.equals(servlet.getServletClass())) continue;
            jsf = servlet;
        }
        if (jsf != null && jsf.getMultipartConfig() == null) {
            jsf.setMultipartConfig(new MultipartConfigMetaData());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

