/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReattachSessionMessage
extends PacketImpl {
    private String name;
    private int lastConfirmedCommandID;

    public ReattachSessionMessage(String name, int lastConfirmedCommandID) {
        super((byte)32);
        this.name = name;
        this.lastConfirmedCommandID = lastConfirmedCommandID;
    }

    public ReattachSessionMessage() {
        super((byte)32);
    }

    public String getName() {
        return this.name;
    }

    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeInt(this.lastConfirmedCommandID);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.name = buffer.readString();
        this.lastConfirmedCommandID = buffer.readInt();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.lastConfirmedCommandID;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReattachSessionMessage)) {
            return false;
        }
        ReattachSessionMessage other = (ReattachSessionMessage)obj;
        if (this.lastConfirmedCommandID != other.lastConfirmedCommandID) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

