/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.IOException;
import javax.management.MBeanServer;
import org.jboss.as.jmx.BlockingNotificationMBeanServer;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.ServerInterceptorFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remotingjmx.RemotingConnectorServer;
import org.jboss.remotingjmx.ServerMessageInterceptorFactory;

public class RemotingConnectorService
implements Service<RemotingConnectorServer> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jmx", "remoting-connector-ref"});
    private RemotingConnectorServer server;
    private final InjectedValue<MBeanServer> mBeanServer = new InjectedValue();
    private final InjectedValue<Endpoint> endpoint = new InjectedValue();
    private final String resolvedDomain;
    private final String expressionsDomain;

    private RemotingConnectorService(String resolvedDomain, String expressionsDomain) {
        this.resolvedDomain = resolvedDomain;
        this.expressionsDomain = expressionsDomain;
    }

    public synchronized void start(StartContext context) throws StartException {
        BlockingNotificationMBeanServer forwarder = new BlockingNotificationMBeanServer((MBeanServer)this.mBeanServer.getValue(), this.resolvedDomain, this.expressionsDomain);
        this.server = new RemotingConnectorServer((MBeanServer)forwarder, (Endpoint)this.endpoint.getValue(), (ServerMessageInterceptorFactory)new ServerInterceptorFactory());
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized RemotingConnectorServer getValue() throws IllegalStateException, IllegalArgumentException {
        return this.server;
    }

    static void addService(ServiceTarget target, ServiceName remotingCapability, String resolvedDomain, String expressionsDomain) {
        RemotingConnectorService service = new RemotingConnectorService(resolvedDomain, expressionsDomain);
        target.addService(SERVICE_NAME, (Service)service).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.mBeanServer).addDependency(remotingCapability, Endpoint.class, service.endpoint).install();
    }
}

