/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.server;

import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonContextSender;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonPlugSender;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.exceptions.ActiveMQAMQPInternalErrorException;
import org.proton.plug.logger.ActiveMQAMQPProtocolMessageBundle;

public class ProtonServerSenderContext
extends AbstractProtonContextSender
implements ProtonPlugSender {
    private static final Symbol SELECTOR = Symbol.getSymbol((String)"jms-selector");
    private static final Symbol COPY = Symbol.valueOf((String)"copy");
    private Object brokerConsumer;

    public ProtonServerSenderContext(AbstractConnectionContext connection, Sender sender, AbstractProtonSessionContext protonSession, AMQPSessionCallback server) {
        super(connection, sender, protonSession, server);
    }

    public Object getBrokerConsumer() {
        return this.brokerConsumer;
    }

    @Override
    public void onFlow(int currentCredits) {
        super.onFlow(currentCredits);
        this.sessionSPI.onFlowConsumer(this.brokerConsumer, currentCredits);
    }

    @Override
    public void start() throws ActiveMQAMQPException {
        super.start();
        try {
            this.sessionSPI.startSender(this.brokerConsumer);
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorStartingConsumer(e.getMessage());
        }
    }

    @Override
    public void initialise() throws Exception {
        DescribedType value;
        Map filter;
        super.initialise();
        Source source = (Source)this.sender.getRemoteSource();
        String selector = null;
        Map map = filter = source == null ? null : source.getFilter();
        if (filter != null && (value = (DescribedType)filter.get(SELECTOR)) != null) {
            selector = value.getDescribed().toString();
        }
        if (source != null) {
            String queue;
            if (source.getDynamic()) {
                queue = UUID.randomUUID().toString();
                try {
                    this.sessionSPI.createTemporaryQueue(queue);
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                }
                source.setAddress(queue);
            } else {
                queue = source.getAddress();
                if (queue == null) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressNotSet();
                }
                try {
                    if (!this.sessionSPI.queueQuery(queue)) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                    }
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
            boolean browseOnly = source.getDistributionMode() != null && source.getDistributionMode().equals(COPY);
            try {
                this.brokerConsumer = this.sessionSPI.createSender(this, queue, selector, browseOnly);
            }
            catch (Exception e) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
            }
        }
    }

    @Override
    public void close() throws ActiveMQAMQPException {
        super.close();
        try {
            this.sessionSPI.closeSender(this.brokerConsumer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ActiveMQAMQPInternalErrorException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        Object message = delivery.getContext();
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        DeliveryState remoteState = delivery.getRemoteState();
        if (remoteState != null) {
            if (remoteState instanceof Accepted) {
                try {
                    this.sessionSPI.ack(this.brokerConsumer, message);
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                }
            }
            if (remoteState instanceof Released) {
                try {
                    this.sessionSPI.cancel(this.brokerConsumer, message, false);
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            if (remoteState instanceof Rejected || remoteState instanceof Modified) {
                try {
                    this.sessionSPI.cancel(this.brokerConsumer, message, true);
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            if (!preSettle) {
                this.protonSession.replaceTag(delivery.getTag());
            }
            Object object = this.connection.getLock();
            synchronized (object) {
                delivery.settle();
                this.sender.offer(1);
            }
        }
    }

    @Override
    public synchronized void checkState() {
        super.checkState();
        this.sessionSPI.resumeDelivery(this.brokerConsumer);
    }

    @Override
    public int deliverMessage(Object message, int deliveryCount) throws Exception {
        ProtonJMessage serverMessage;
        if (this.closed) {
            System.err.println("Message can't be delivered as it's closed");
            return 0;
        }
        try {
            serverMessage = this.sessionSPI.encodeMessage(message, deliveryCount);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
        }
        return this.performSend(serverMessage, message);
    }
}

