/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class ScheduleSchedulerCommand
implements Command<Void, Scheduler> {
    private static final long serialVersionUID = -2606847692331278614L;
    private transient ImmutableSessionMetaData metaData;
    private final String sessionId;

    public ScheduleSchedulerCommand(String sessionId, ImmutableSessionMetaData metaData) {
        this.sessionId = sessionId;
        this.metaData = metaData;
    }

    public Void execute(Scheduler scheduler) {
        scheduler.schedule(this.sessionId, this.metaData);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Instant creationTime = this.metaData.getCreationTime();
        Duration maxInactiveInterval = this.metaData.getMaxInactiveInterval();
        Duration lastAccessedDuration = Duration.between(creationTime, this.metaData.getLastAccessedTime());
        out.defaultWriteObject();
        out.writeObject(creationTime);
        out.writeObject(maxInactiveInterval);
        out.writeObject(lastAccessedDuration);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Instant creationTime = (Instant)in.readObject();
        Duration maxInactiveInterval = (Duration)in.readObject();
        Duration lastAccessedDuration = (Duration)in.readObject();
        SimpleSessionCreationMetaData creationMetaData = new SimpleSessionCreationMetaData(creationTime);
        creationMetaData.setMaxInactiveInterval(maxInactiveInterval);
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        accessMetaData.setLastAccessedDuration(lastAccessedDuration);
        this.metaData = new SimpleSessionMetaData(creationMetaData, accessMetaData);
    }
}

