/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jboss.remoting3.remote.RemoteLogger;
import org.xnio.Pool;
import org.xnio.Pooled;

final class DebuggingBufferPool
implements Pool<ByteBuffer> {
    private final Pool<ByteBuffer> delegate;

    DebuggingBufferPool(Pool<ByteBuffer> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Pooled<ByteBuffer> allocate() {
        final Pooled<ByteBuffer> real = this.delegate.allocate();
        final StackTraceElement first = DebuggingBufferPool.findElement(new Throwable().getStackTrace());
        return new Pooled<ByteBuffer>(){
            private final ArrayList<StackTraceElement> users = new ArrayList(0);
            private boolean freed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void discard() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.users.clear();
                    this.freed = true;
                }
                real.discard();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void free() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.users.clear();
                    this.freed = true;
                }
                real.free();
            }

            @Override
            public void close() {
                this.free();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ByteBuffer getResource() throws IllegalStateException {
                ByteBuffer buffer = (ByteBuffer)real.getResource();
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.users.add(DebuggingBufferPool.findElement(new Throwable().getStackTrace()));
                    return buffer;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.freed) {
                        StringBuilder b = new StringBuilder();
                        b.append("Leaked a buffer which was allocated at: ");
                        DebuggingBufferPool.format(b, first);
                        b.append(" and used at:");
                        for (StackTraceElement user : this.users) {
                            b.append('\n');
                            b.append('\t');
                            DebuggingBufferPool.format(b, user);
                        }
                        RemoteLogger.log.info(b.toString());
                        this.discard();
                        super.finalize();
                    }
                }
            }
        };
    }

    static StackTraceElement findElement(StackTraceElement[] elements) {
        for (StackTraceElement element : elements) {
            String className = element.getClassName();
            if (className == null || className.startsWith(DebuggingBufferPool.class.getName()) || "allocate".equals(element.getMethodName())) continue;
            return element;
        }
        return new StackTraceElement("Unknown user", "", "", 0);
    }

    static void format(StringBuilder b, StackTraceElement e) {
        b.append(e.getClassName());
        b.append('#');
        b.append(e.getMethodName());
        b.append('(');
        String fileName = e.getFileName();
        b.append(fileName == null ? "<unknown file>" : fileName);
        b.append(':');
        int lineNumber = e.getLineNumber();
        if (lineNumber == -2) {
            b.append("<native>");
        } else if (lineNumber == -1) {
            b.append("<unknown line>");
        } else {
            b.append(lineNumber);
        }
        b.append(')');
    }
}

