/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ArgumentsTools;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.internal.impl.EntitiesAtRevisionQuery;
import org.hibernate.envers.query.internal.impl.EntitiesModifiedAtRevisionQuery;
import org.hibernate.envers.query.internal.impl.RevisionsOfEntityQuery;

public class AuditQueryCreator {
    private final EnversService enversService;
    private final AuditReaderImplementor auditReaderImplementor;

    public AuditQueryCreator(EnversService enversService, AuditReaderImplementor auditReaderImplementor) {
        this.enversService = enversService;
        this.auditReaderImplementor = auditReaderImplementor;
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        return new EntitiesAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, revision, false);
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, String entityName, Number revision) {
        return this.forEntitiesAtRevision(c, entityName, revision, false);
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, String entityName, Number revision, boolean includeDeletions) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        return new EntitiesAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, entityName, revision, includeDeletions);
    }

    public AuditQuery forEntitiesModifiedAtRevision(Class<?> c, String entityName, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        return new EntitiesModifiedAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, entityName, revision);
    }

    public AuditQuery forEntitiesModifiedAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        return new EntitiesModifiedAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, revision);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        c = EntityTools.getTargetClassIfProxied(c);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, c, selectEntitiesOnly, selectDeletedEntities);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        c = EntityTools.getTargetClassIfProxied(c);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, c, entityName, selectEntitiesOnly, selectDeletedEntities);
    }
}

