/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.message.impl.MessageImpl;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;

public class RemoteQueueBindingImpl
implements RemoteQueueBinding {
    private final SimpleString address;
    private final Queue storeAndForwardQueue;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final long remoteQueueID;
    private final Filter queueFilter;
    private final Set<Filter> filters = new HashSet<Filter>();
    private final Map<SimpleString, Integer> filterCounts = new HashMap<SimpleString, Integer>();
    private int consumerCount;
    private final SimpleString idsHeaderName;
    private final long id;
    private final int distance;
    private boolean connected = true;

    public RemoteQueueBindingImpl(long id, SimpleString address, SimpleString uniqueName, SimpleString routingName, Long remoteQueueID, SimpleString filterString, Queue storeAndForwardQueue, SimpleString bridgeName, int distance) throws Exception {
        this.id = id;
        this.address = address;
        this.storeAndForwardQueue = storeAndForwardQueue;
        this.uniqueName = uniqueName;
        this.routingName = routingName;
        this.remoteQueueID = remoteQueueID;
        this.queueFilter = FilterImpl.createFilter(filterString);
        this.idsHeaderName = MessageImpl.HDR_ROUTE_TO_IDS.concat(bridgeName);
        this.distance = distance;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.storeAndForwardQueue;
    }

    @Override
    public Queue getQueue() {
        return this.storeAndForwardQueue;
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public SimpleString getClusterName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public BindingType getType() {
        return BindingType.REMOTE_QUEUE;
    }

    @Override
    public Filter getFilter() {
        return this.queueFilter;
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    @Override
    public synchronized boolean isHighAcceptPriority(ServerMessage message) {
        if (this.consumerCount == 0) {
            return false;
        }
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Filter filter : this.filters) {
            if (!filter.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unproposed(SimpleString groupID) {
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) {
        this.addRouteContextToMessage(message);
        List<Queue> durableQueuesOnContext = context.getDurableQueues(this.storeAndForwardQueue.getAddress());
        if (!durableQueuesOnContext.contains(this.storeAndForwardQueue)) {
            context.addQueue(this.storeAndForwardQueue.getAddress(), this.storeAndForwardQueue);
        }
    }

    @Override
    public void routeWithAck(ServerMessage message, RoutingContext context) {
        this.addRouteContextToMessage(message);
        List<Queue> durableQueuesOnContext = context.getDurableQueues(this.storeAndForwardQueue.getAddress());
        if (!durableQueuesOnContext.contains(this.storeAndForwardQueue)) {
            context.addQueueWithAck(this.storeAndForwardQueue.getAddress(), this.storeAndForwardQueue);
        }
    }

    @Override
    public synchronized void addConsumer(SimpleString filterString) throws Exception {
        if (filterString != null) {
            Integer i = this.filterCounts.get(filterString);
            if (i == null) {
                this.filterCounts.put(filterString, 1);
                this.filters.add(FilterImpl.createFilter(filterString));
            } else {
                this.filterCounts.put(filterString, i + 1);
            }
        }
        ++this.consumerCount;
    }

    @Override
    public synchronized void removeConsumer(SimpleString filterString) throws Exception {
        Integer i;
        if (filterString != null && (i = this.filterCounts.get(filterString)) != null) {
            int ii = i - 1;
            if (ii == 0) {
                this.filterCounts.remove(filterString);
                this.filters.remove(FilterImpl.createFilter(filterString));
            } else {
                this.filterCounts.put(filterString, ii);
            }
        }
        --this.consumerCount;
    }

    @Override
    public void reset() {
        this.consumerCount = 0;
        this.filterCounts.clear();
        this.filters.clear();
    }

    @Override
    public synchronized int consumerCount() {
        return this.consumerCount;
    }

    public String toString() {
        return "RemoteQueueBindingImpl(" + (this.connected ? "connected" : "disconnected") + ")[address=" + this.address + ", consumerCount=" + this.consumerCount + ", distance=" + this.distance + ", filters=" + this.filters + ", id=" + this.id + ", idsHeaderName=" + this.idsHeaderName + ", queueFilter=" + this.queueFilter + ", remoteQueueID=" + this.remoteQueueID + ", routingName=" + this.routingName + ", storeAndForwardQueue=" + this.storeAndForwardQueue + ", uniqueName=" + this.uniqueName + "]";
    }

    @Override
    public String toManagementString() {
        return "RemoteQueueBindingImpl [address=" + this.address + ", storeAndForwardQueue=" + this.storeAndForwardQueue.getName() + ", remoteQueueID=" + this.remoteQueueID + "]";
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public void close() throws Exception {
        this.storeAndForwardQueue.close();
    }

    private void addRouteContextToMessage(ServerMessage message) {
        byte[] ids = message.getBytesProperty(this.idsHeaderName);
        if (ids == null) {
            ids = new byte[8];
        } else {
            byte[] newIds = new byte[ids.length + 8];
            System.arraycopy(ids, 0, newIds, 8, ids.length);
            ids = newIds;
        }
        ByteBuffer buff = ByteBuffer.wrap(ids);
        buff.putLong(this.remoteQueueID);
        message.putBytesProperty(this.idsHeaderName, ids);
        if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
            ActiveMQServerLogger.LOGGER.trace("Adding remoteQueue ID = " + this.remoteQueueID + " into message=" + message + " store-forward-queue=" + this.storeAndForwardQueue);
        }
    }

    @Override
    public long getRemoteQueueID() {
        return this.remoteQueueID;
    }
}

