/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.impl.MessageImpl;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.Redistributor;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.BindingsTransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.LinkedListIterator;
import org.apache.activemq.artemis.utils.PriorityLinkedList;
import org.apache.activemq.artemis.utils.PriorityLinkedListImpl;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.TypedProperties;

public class QueueImpl
implements Queue {
    private static final boolean isTrace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    public static final int REDISTRIBUTOR_BATCH_SIZE = 100;
    public static final int NUM_PRIORITIES = 10;
    public static final int MAX_DELIVERIES_IN_LOOP = 1000;
    public static final int CHECK_QUEUE_SIZE_PERIOD = 100;
    public static final int DELIVERY_TIMEOUT = 1000;
    private static final int FLUSH_TIMEOUT = 10000;
    public static final int DEFAULT_FLUSH_LIMIT = 500;
    private final long id;
    private final SimpleString name;
    private final SimpleString user;
    private volatile Filter filter;
    private final boolean durable;
    private final boolean temporary;
    private final boolean autoCreated;
    private final PostOffice postOffice;
    private volatile boolean queueDestroyed = false;
    private final PageSubscription pageSubscription;
    private ReferenceCounter refCountForConsumers;
    private final LinkedListIterator<PagedReference> pageIterator;
    private final ConcurrentLinkedQueue<MessageReference> intermediateMessageReferences = new ConcurrentLinkedQueue();
    private final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl(10);
    private final AtomicInteger pagedReferences = new AtomicInteger(0);
    private final AtomicInteger queueMemorySize = new AtomicInteger(0);
    private volatile boolean consumersChanged = true;
    private final List<ConsumerHolder> consumerList = new CopyOnWriteArrayList<ConsumerHolder>();
    private final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private long messagesAdded;
    private long messagesAcknowledged;
    protected final AtomicInteger deliveringCount = new AtomicInteger(0);
    private boolean paused;
    private static final int MAX_SCHEDULED_RUNNERS = 2;
    private final AtomicInteger scheduledRunners = new AtomicInteger(0);
    private final Runnable deliverRunner = new DeliverRunner();
    private volatile boolean depagePending = false;
    private final StorageManager storageManager;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private Redistributor redistributor;
    private final Set<ScheduledFuture<?>> futures = new ConcurrentHashSet();
    private ScheduledFuture<?> redistributorFuture;
    private ScheduledFuture<?> checkQueueSizeFuture;
    private final Set<Consumer> consumerSet = new HashSet<Consumer>();
    private final Map<SimpleString, Consumer> groups = new HashMap<SimpleString, Consumer>();
    private volatile SimpleString expiryAddress;
    private int pos;
    private final Executor executor;
    private boolean internalQueue;
    private volatile long lastDirectDeliveryCheck = 0L;
    private volatile boolean directDeliver = true;
    private AddressSettingsRepositoryListener addressSettingsRepositoryListener;
    private final ExpiryScanner expiryScanner = new ExpiryScanner();
    private final ReusableLatch deliveriesInTransit = new ReusableLatch(0);
    private AtomicLong queueRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong messagesAddedSnapshot = new AtomicLong(0L);
    private ScheduledFuture slowConsumerReaperFuture;
    private SlowConsumerReaperRunnable slowConsumerReaperRunnable;
    private final Object directDeliveryGuard = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SimpleString> getGroupsUsed() {
        final CountDownLatch flush = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                flush.countDown();
            }
        });
        try {
            flush.await(10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            ArrayList<SimpleString> groupsUsed = new ArrayList<SimpleString>();
            groupsUsed.addAll(this.groups.keySet());
            return groupsUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("queueMemorySize=" + this.queueMemorySize);
        for (ConsumerHolder holder : this.consumerList) {
            out.println("consumer: " + holder.consumer.debug());
        }
        for (MessageReference reference : this.intermediateMessageReferences) {
            out.print("Intermediate reference:" + reference);
        }
        if (this.intermediateMessageReferences.isEmpty()) {
            out.println("No intermediate references");
        }
        boolean foundRef = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            LinkedListIterator iter = this.messageReferences.iterator();
            while (iter.hasNext()) {
                foundRef = true;
                out.println("reference = " + iter.next());
            }
        }
        if (!foundRef) {
            out.println("No permanent references on queue");
        }
        System.out.println(str.toString());
        return str.toString();
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        this(id, address, name, filter, null, user, durable, temporary, autoCreated, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor);
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        this.id = id;
        this.address = address;
        this.name = name;
        this.filter = filter;
        this.pageSubscription = pageSubscription;
        this.durable = durable;
        this.temporary = temporary;
        this.autoCreated = autoCreated;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor);
        if (addressSettingsRepository != null) {
            this.addressSettingsRepositoryListener = new AddressSettingsRepositoryListener();
            addressSettingsRepository.registerListener(this.addressSettingsRepositoryListener);
        } else {
            this.expiryAddress = null;
        }
        if (pageSubscription != null) {
            pageSubscription.setQueue(this);
            this.pageIterator = pageSubscription.iterator();
        } else {
            this.pageIterator = null;
        }
        this.executor = executor;
        this.user = user;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    public boolean isExclusive() {
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        context.addQueue(this.address, this);
    }

    @Override
    public void routeWithAck(ServerMessage message, RoutingContext context) {
        context.addQueueWithAck(this.address, this);
    }

    @Override
    public synchronized void setConsumersRefCount(ReferenceCounter referenceCounter) {
        if (this.refCountForConsumers == null) {
            this.refCountForConsumers = referenceCounter;
        }
    }

    @Override
    public ReferenceCounter getConsumersRefCount() {
        return this.refCountForConsumers;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public PageSubscription getPageSubscription() {
        return this.pageSubscription;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void unproposed(final SimpleString groupID) {
        if (groupID.toString().endsWith("." + this.getName())) {
            final SimpleString groupIDToRemove = (SimpleString)groupID.subSequence(0, groupID.length() - this.getName().length() - 1);
            this.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueueImpl queueImpl = QueueImpl.this;
                    synchronized (queueImpl) {
                        if (QueueImpl.this.groups.remove(groupIDToRemove) != null) {
                            ActiveMQServerLogger.LOGGER.debug("Removing group after unproposal " + groupID + " from queue " + QueueImpl.this);
                        } else {
                            ActiveMQServerLogger.LOGGER.debug("Couldn't remove Removing group " + groupIDToRemove + " after unproposal on queue " + QueueImpl.this);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void addHead(MessageReference ref) {
        this.flushDeliveriesInTransit();
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
            return;
        }
        this.internalAddHead(ref);
        this.directDeliver = false;
    }

    @Override
    public synchronized void addHead(List<MessageReference> refs) {
        this.flushDeliveriesInTransit();
        for (MessageReference ref : refs) {
            this.addHead(ref);
        }
        this.resetAllIterators();
        this.deliverAsync();
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        if (!this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            this.internalAddTail(ref);
        }
        this.directDeliver = false;
        ++this.messagesAdded;
    }

    @Override
    public void addTail(MessageReference ref) {
        this.addTail(ref, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTail(MessageReference ref, boolean direct) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                ++this.messagesAdded;
            }
            return;
        }
        Object object = this.directDeliveryGuard;
        synchronized (object) {
            if (!this.directDeliver && direct && System.currentTimeMillis() - this.lastDirectDeliveryCheck > 100L) {
                this.lastDirectDeliveryCheck = System.currentTimeMillis();
                if (this.intermediateMessageReferences.isEmpty() && this.messageReferences.isEmpty() && !this.pageIterator.hasNext() && !this.pageSubscription.isPaging() && this.flushExecutor() && this.flushDeliveriesInTransit()) {
                    this.directDeliver = true;
                }
            }
        }
        if (direct && this.directDeliver && this.deliveriesInTransit.getCount() == 0 && this.deliverDirect(ref)) {
            return;
        }
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.intermediateMessageReferences.add(ref);
        this.directDeliver = false;
        this.deliverAsync();
    }

    private boolean flushDeliveriesInTransit() {
        try {
            if (this.deliveriesInTransit.await(1000L)) {
                return true;
            }
            ActiveMQServerLogger.LOGGER.timeoutFlushInTransit(this.getName().toString(), this.getAddress().toString());
            return false;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void forceDelivery() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Force delivery scheduling depage");
            }
            this.scheduleDepage(false);
        }
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("Force delivery deliverying async");
        }
        this.deliverAsync();
    }

    @Override
    public void deliverAsync() {
        if (this.scheduledRunners.get() < 2) {
            this.scheduledRunners.incrementAndGet();
            try {
                this.getExecutor().execute(this.deliverRunner);
            }
            catch (RejectedExecutionException ignored) {
                this.scheduledRunners.decrementAndGet();
            }
            this.checkDepage();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.checkQueueSizeFuture != null) {
            this.checkQueueSizeFuture.cancel(false);
        }
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QueueImpl.this.cancelRedistributor();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        });
        if (this.addressSettingsRepository != null) {
            this.addressSettingsRepository.unRegisterListener(this.addressSettingsRepositoryListener);
        }
    }

    @Override
    public Executor getExecutor() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            return this.pageSubscription.getExecutor();
        }
        return this.executor;
    }

    public void deliverNow() {
        this.deliverAsync();
        this.flushExecutor();
    }

    @Override
    public boolean flushExecutor() {
        boolean ok = this.internalFlushExecutor(10000L);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.errorFlushingExecutorsOnQueue();
        }
        return ok;
    }

    private boolean internalFlushExecutor(long timeout) {
        FutureLatch future = new FutureLatch();
        this.getExecutor().execute((Runnable)future);
        boolean result = future.await(timeout);
        if (!result) {
            ActiveMQServerLogger.LOGGER.queueBusy(this.name.toString(), timeout);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws Exception {
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug(this + " adding consumer " + consumer);
        }
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.flushDeliveriesInTransit();
            this.consumersChanged = true;
            this.cancelRedistributor();
            this.consumerList.add(new ConsumerHolder(consumer));
            this.consumerSet.add(consumer);
            if (this.refCountForConsumers != null) {
                this.refCountForConsumers.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.consumersChanged = true;
            for (ConsumerHolder holder : this.consumerList) {
                if (holder.consumer != consumer) continue;
                if (holder.iter != null) {
                    holder.iter.close();
                }
                this.consumerList.remove(holder);
                break;
            }
            if (this.pos > 0 && this.pos >= this.consumerList.size()) {
                this.pos = this.consumerList.size() - 1;
            }
            this.consumerSet.remove(consumer);
            LinkedList<SimpleString> groupsToRemove = null;
            for (SimpleString groupID : this.groups.keySet()) {
                if (consumer != this.groups.get(groupID)) continue;
                if (groupsToRemove == null) {
                    groupsToRemove = new LinkedList<SimpleString>();
                }
                groupsToRemove.add(groupID);
            }
            if (groupsToRemove != null) {
                for (SimpleString groupID : groupsToRemove) {
                    this.groups.remove(groupID);
                }
            }
            if (this.refCountForConsumers != null) {
                this.refCountForConsumers.decrement();
            }
        }
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        if (this.redistributorFuture != null) {
            this.redistributorFuture.cancel(false);
            this.futures.remove(this.redistributorFuture);
        }
        if (this.redistributor != null) {
            this.deliverAsync();
        }
        if (delay > 0L) {
            if (this.consumerSet.isEmpty()) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.redistributorFuture = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
                this.futures.add(this.redistributorFuture);
            }
        } else {
            this.internalAddRedistributor(this.executor);
        }
    }

    @Override
    public synchronized void cancelRedistributor() throws Exception {
        if (this.redistributor != null) {
            this.redistributor.stop();
            Redistributor redistributorToRemove = this.redistributor;
            this.redistributor = null;
            this.removeConsumer(redistributorToRemove);
        }
        if (this.redistributorFuture != null) {
            this.redistributorFuture.cancel(false);
            this.redistributorFuture = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.checkQueueSizeFuture != null) {
            this.checkQueueSizeFuture.cancel(false);
        }
        this.cancelRedistributor();
        super.finalize();
    }

    @Override
    public synchronized int getConsumerCount() {
        return this.consumerSet.size();
    }

    public synchronized Set<Consumer> getConsumers() {
        return new HashSet<Consumer>(this.consumerSet);
    }

    @Override
    public boolean hasMatchingConsumer(ServerMessage message) {
        for (ConsumerHolder holder : this.consumerList) {
            Consumer consumer = holder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter1 = consumer.getFilter();
            if (filter1 == null) {
                return true;
            }
            if (!filter1.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedListIterator<MessageReference> iterator() {
        return new SynchronizedIterator((LinkedListIterator<MessageReference>)this.messageReferences.iterator());
    }

    public TotalQueueIterator totalIterator() {
        return new TotalQueueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MessageReference removeReferenceWithID(long id1) throws Exception {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            MessageReference removed = null;
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                iterator.remove();
                this.refRemoved(ref);
                removed = ref;
                break;
            }
            if (removed == null) {
                removed = this.scheduledDeliveryHandler.removeReferenceWithID(id1);
            }
            MessageReference messageReference = removed;
            return messageReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MessageReference getReference(long id1) throws ActiveMQException {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                MessageReference messageReference = ref;
                return messageReference;
            }
            MessageReference messageReference = null;
            return messageReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMessageCount() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.pageSubscription != null) {
                return (long)(this.messageReferences.size() + this.getScheduledCount() + this.deliveringCount.get()) + this.pageSubscription.getMessageCount();
            }
            return this.messageReferences.size() + this.getScheduledCount() + this.deliveringCount.get();
        }
    }

    @Override
    public synchronized int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    @Override
    public Map<String, List<MessageReference>> getDeliveringMessages() {
        List<ConsumerHolder> consumerListClone = this.cloneConsumersList();
        HashMap<String, List<MessageReference>> mapReturn = new HashMap<String, List<MessageReference>>();
        for (ConsumerHolder holder : consumerListClone) {
            List<MessageReference> msgs = holder.consumer.getDeliveringMessages();
            if (msgs == null || msgs.size() <= 0) continue;
            mapReturn.put(holder.consumer.toManagementString(), msgs);
        }
        return mapReturn;
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringCount.get();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        if (ref.isPaged()) {
            this.pageSubscription.ack((PagedReference)ref);
            this.postAcknowledge(ref);
        } else {
            boolean durableRef;
            ServerMessage message = ref.getMessage();
            boolean bl = durableRef = message.isDurable() && this.durable;
            if (durableRef) {
                this.storageManager.storeAcknowledge(this.id, message.getMessageID());
            }
            this.postAcknowledge(ref);
        }
        ++this.messagesAcknowledged;
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        if (ref.isPaged()) {
            this.pageSubscription.ackTx(tx, (PagedReference)ref);
            this.getRefsOperation(tx).addAck(ref);
        } else {
            boolean durableRef;
            ServerMessage message = ref.getMessage();
            boolean bl = durableRef = message.isDurable() && this.durable;
            if (durableRef) {
                this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
                tx.setContainsPersistent();
            }
            this.getRefsOperation(tx).addAck(ref);
        }
        ++this.messagesAcknowledged;
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        ServerMessage message = ref.getMessage();
        if (message.isDurable() && this.durable) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
        this.incDelivering();
        ++this.messagesAcknowledged;
    }

    private RefsOperation getRefsOperation(Transaction tx) {
        return this.getRefsOperation(tx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefsOperation getRefsOperation(Transaction tx, boolean ignoreRedlieveryCheck) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = tx.createRefsOperation(this);
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            if (ignoreRedlieveryCheck) {
                oper.setIgnoreRedeliveryCheck();
            }
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) {
        this.cancel(tx, reference, false);
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference, boolean ignoreRedeliveryCheck) {
        this.getRefsOperation(tx, ignoreRedeliveryCheck).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference, long timeBase) throws Exception {
        if (this.checkRedelivery(reference, timeBase, false)) {
            if (!this.scheduledDeliveryHandler.checkAndSchedule(reference, false)) {
                this.internalAddHead(reference);
            }
            this.resetAllIterators();
        } else {
            this.decDelivering();
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        if (this.expiryAddress != null) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("moving expired reference " + ref + " to address = " + this.expiryAddress + " from queue=" + this.getName());
            }
            this.move(this.expiryAddress, ref, true, false);
        } else {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("expiry is null, just acking expired message for reference " + ref + " from queue=" + this.getName());
            }
            this.acknowledge(ref);
        }
    }

    @Override
    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    @Override
    public void referenceHandled() {
        this.incDelivering();
    }

    @Override
    public void incrementMesssagesAdded() {
        ++this.messagesAdded;
    }

    @Override
    public void deliverScheduledMessages() throws ActiveMQException {
        List<MessageReference> scheduledMessages = this.scheduledDeliveryHandler.cancel(null);
        if (scheduledMessages != null && scheduledMessages.size() > 0) {
            for (MessageReference ref : scheduledMessages) {
                ref.getMessage().putLongProperty(MessageImpl.HDR_SCHEDULED_DELIVERY_TIME, ref.getScheduledDeliveryTime());
                ref.setScheduledDeliveryTime(0L);
            }
            this.addHead(scheduledMessages);
        }
    }

    @Override
    public long getMessagesAdded() {
        if (this.pageSubscription != null) {
            return this.messagesAdded + this.pageSubscription.getCounter().getValue() - (long)this.pagedReferences.get();
        }
        return this.messagesAdded;
    }

    @Override
    public long getMessagesAcknowledged() {
        return this.messagesAcknowledged;
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteAllReferences(500);
    }

    @Override
    public int deleteAllReferences(int flushLimit) throws Exception {
        return this.deleteMatchingReferences(flushLimit, null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        return this.deleteMatchingReferences(500, filter);
    }

    @Override
    public synchronized int deleteMatchingReferences(int flushLimit, Filter filter1) throws Exception {
        return this.iterQueue(flushLimit, filter1, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.incDelivering();
                QueueImpl.this.acknowledge(tx, ref);
                QueueImpl.this.refRemoved(ref);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int iterQueue(int flushLimit, Filter filter1, QueueIterateAction messageAction) throws Exception {
        int count = 0;
        int txCount = 0;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.isPaged() && this.queueDestroyed || filter1 != null && !filter1.match(ref.getMessage())) continue;
                messageAction.actMessage(tx, ref);
                iter.remove();
                ++txCount;
                ++count;
            }
            if (txCount > 0) {
                tx.commit();
                tx = new TransactionImpl(this.storageManager);
                txCount = 0;
            }
            List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter1);
            for (MessageReference messageReference : cancelled) {
                messageAction.actMessage(tx, messageReference);
                ++count;
                ++txCount;
            }
            if (txCount > 0) {
                tx.commit();
                tx = new TransactionImpl(this.storageManager);
                txCount = 0;
            }
            if (this.pageIterator != null && !this.queueDestroyed) {
                while (this.pageIterator.hasNext()) {
                    PagedReference reference = (PagedReference)this.pageIterator.next();
                    this.pageIterator.remove();
                    if (filter1 == null || filter1.match(reference.getMessage())) {
                        ++count;
                        ++txCount;
                        messageAction.actMessage(tx, reference);
                    } else {
                        this.addTail(reference, false);
                    }
                    if (txCount <= 0 || txCount % flushLimit != 0) continue;
                    tx.commit();
                    tx = new TransactionImpl(this.storageManager);
                    txCount = 0;
                }
            }
            if (txCount > 0) {
                tx.commit();
                tx = null;
            }
            if (this.filter != null && !this.queueDestroyed && this.pageSubscription != null) {
                this.scheduleDepage(false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public void destroyPaging() throws Exception {
        if (this.pageSubscription != null) {
            this.pageSubscription.destroy();
            this.pageSubscription.cleanupEntries(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering();
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                deleted = true;
                break;
            }
            if (!deleted) {
                deleted = this.scheduledDeliveryHandler.removeReferenceWithID(messageID) != null;
            }
            tx.commit();
            boolean bl = deleted;
            return bl;
        }
    }

    @Override
    public void deleteQueue() throws Exception {
        this.deleteQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(boolean removeConsumers) throws Exception {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.queueDestroyed = true;
        }
        BindingsTransactionImpl tx = new BindingsTransactionImpl(this.storageManager);
        try {
            this.postOffice.removeBinding(this.name, tx, true);
            this.deleteAllReferences();
            this.destroyPaging();
            if (removeConsumers) {
                for (ConsumerHolder consumerHolder : this.consumerList) {
                    consumerHolder.consumer.disconnect();
                }
            }
            if (this.isDurable()) {
                this.storageManager.deleteQueueBinding(tx.getID(), this.getID());
                tx.setContainsPersistent();
            }
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean expireReference(long messageID) throws Exception {
        if (this.expiryAddress != null && this.expiryAddress.equals((Object)this.address)) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("Cannot expire from " + this.address + " into " + this.expiryAddress);
            }
            return false;
        }
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering();
                this.expire(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int expireReferences(Filter filter) throws Exception {
        if (this.expiryAddress != null && this.expiryAddress.equals((Object)this.address)) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("Cannot expire from " + this.address + " into " + this.expiryAddress);
            }
            return 0;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering();
                this.expire(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            tx.commit();
            int n = count;
            return n;
        }
    }

    @Override
    public void expireReferences() {
        if (this.expiryAddress != null && this.expiryAddress.equals((Object)this.address)) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("Cannot expire from " + this.address + " into " + this.expiryAddress);
            }
            return;
        }
        if (!this.queueDestroyed && this.expiryScanner.scannerRunning.get() == 0) {
            this.expiryScanner.scannerRunning.incrementAndGet();
            this.getExecutor().execute(this.expiryScanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering();
                this.sendToDeadLetterAddress(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering();
                this.sendToDeadLetterAddress(ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public boolean moveReference(long messageID, SimpleString toAddress) throws Exception {
        return this.moveReference(messageID, toAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean moveReference(long messageID, SimpleString toAddress, boolean rejectDuplicate) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                this.incDelivering();
                try {
                    this.move(toAddress, ref, false, rejectDuplicate);
                }
                catch (Exception e) {
                    this.decDelivering();
                    throw e;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress) throws Exception {
        return this.moveReferences(500, filter, toAddress, false);
    }

    @Override
    public synchronized int moveReferences(int flushLimit, Filter filter, final SimpleString toAddress, final boolean rejectDuplicates) throws Exception {
        final DuplicateIDCache targetDuplicateCache = this.postOffice.getDuplicateIDCache(toAddress);
        return this.iterQueue(flushLimit, filter, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                byte[] duplicateBytes;
                boolean ignored = false;
                QueueImpl.this.incDelivering();
                if (rejectDuplicates && (duplicateBytes = ref.getMessage().getDuplicateIDBytes()) != null && targetDuplicateCache.contains(duplicateBytes)) {
                    ActiveMQServerLogger.LOGGER.messageWithDuplicateID(ref.getMessage().getDuplicateProperty(), toAddress, QueueImpl.this.address, QueueImpl.this.address);
                    QueueImpl.this.acknowledge(tx, ref);
                    ignored = true;
                }
                if (!ignored) {
                    QueueImpl.this.move(toAddress, tx, ref, false, rejectDuplicates);
                }
            }
        });
    }

    public synchronized int moveReferencesBetweenSnFQueues(final SimpleString queueSuffix) throws Exception {
        return this.iterQueue(500, null, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.moveBetweenSnFQueues(queueSuffix, tx, ref);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                ++count;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized void resetAllIterators() {
        for (ConsumerHolder holder : this.consumerList) {
            if (holder.iter != null) {
                holder.iter.close();
            }
            holder.iter = null;
        }
    }

    @Override
    public synchronized void pause() {
        try {
            this.flushDeliveriesInTransit();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
        }
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public boolean isInternalQueue() {
        return this.internalQueue;
    }

    @Override
    public void setInternalQueue(boolean internalQueue) {
        this.internalQueue = internalQueue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueImpl)) {
            return false;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals((Object)qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + ", postOffice=" + this.postOffice + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private synchronized void internalAddTail(MessageReference ref) {
        this.refAdded(ref);
        this.messageReferences.addTail((Object)ref, this.getPriority(ref));
    }

    private void internalAddHead(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addHead((Object)ref, priority);
    }

    private int getPriority(MessageReference ref) {
        try {
            return ref.getMessage().getPriority();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            return 4;
        }
    }

    private synchronized void doInternalPoll() {
        MessageReference ref;
        int added = 0;
        while ((ref = this.intermediateMessageReferences.poll()) != null) {
            this.internalAddTail(ref);
            ++this.messagesAdded;
            if (added++ <= 1000) continue;
            this.deliverAsync();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver() {
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug(this + " doing deliver. messageReferences=" + this.messageReferences.size());
        }
        this.doInternalPoll();
        int noDelivery = 0;
        int size = 0;
        int endPos = -1;
        int handled = 0;
        long timeout = System.currentTimeMillis() + 1000L;
        while (true) {
            MessageReference ref;
            if (handled == 1000) {
                this.deliverAsync();
                return;
            }
            if (System.currentTimeMillis() > timeout) {
                if (isTrace) {
                    ActiveMQServerLogger.LOGGER.trace("delivery has been running for too long. Scheduling another delivery task now");
                }
                this.deliverAsync();
                return;
            }
            Consumer handledconsumer = null;
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.paused || this.consumerList.isEmpty()) {
                    return;
                }
                if (this.messageReferences.size() == 0) {
                    break;
                }
                if (endPos < 0 || this.consumersChanged) {
                    this.consumersChanged = false;
                    size = this.consumerList.size();
                    endPos = this.pos - 1;
                    if (endPos < 0) {
                        endPos = size - 1;
                        noDelivery = 0;
                    }
                }
                ConsumerHolder holder = this.consumerList.get(this.pos);
                Consumer consumer = holder.consumer;
                Consumer groupConsumer = null;
                if (holder.iter == null) {
                    holder.iter = this.messageReferences.iterator();
                }
                if ((ref = holder.iter.hasNext() ? (MessageReference)holder.iter.next() : null) == null) {
                    ++noDelivery;
                } else {
                    HandleStatus status;
                    SimpleString groupID;
                    if (this.checkExpired(ref)) {
                        if (isTrace) {
                            ActiveMQServerLogger.LOGGER.trace("Reference " + ref + " being expired");
                        }
                        holder.iter.remove();
                        this.refRemoved(ref);
                        ++handled;
                        continue;
                    }
                    if (isTrace) {
                        ActiveMQServerLogger.LOGGER.trace("Queue " + this.getName() + " is delivering reference " + ref);
                    }
                    if ((groupID = this.extractGroupID(ref)) != null && (groupConsumer = this.groups.get(groupID)) != null) {
                        consumer = groupConsumer;
                    }
                    if ((status = this.handle(ref, consumer)) == HandleStatus.HANDLED) {
                        this.deliveriesInTransit.countUp();
                        handledconsumer = consumer;
                        holder.iter.remove();
                        this.refRemoved(ref);
                        if (groupID != null && groupConsumer == null) {
                            this.groups.put(groupID, consumer);
                        }
                        ++handled;
                    } else if (status == HandleStatus.BUSY) {
                        holder.iter.repeat();
                        ++noDelivery;
                    } else if (status == HandleStatus.NO_MATCH) {
                        // empty if block
                    }
                }
                if (this.pos == endPos) {
                    if (noDelivery == size) {
                        if (handledconsumer != null) {
                            ActiveMQServerLogger.LOGGER.nonDeliveryHandled();
                        } else {
                            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                                ActiveMQServerLogger.LOGGER.debug(this + "::All the consumers were busy, giving up now");
                            }
                            break;
                        }
                    }
                    noDelivery = 0;
                }
                if (groupConsumer == null) {
                    ++this.pos;
                }
                if (this.pos >= size) {
                    this.pos = 0;
                }
            }
            if (handledconsumer == null) continue;
            this.proceedDeliver(handledconsumer, ref);
        }
        this.checkDepage();
    }

    private void checkDepage() {
        if (this.pageIterator != null && this.pageSubscription.isPaging() && !this.depagePending && this.needsDepage() && this.pageIterator.hasNext()) {
            this.scheduleDepage(false);
        }
    }

    private boolean needsDepage() {
        return (long)this.queueMemorySize.get() < this.pageSubscription.getPagingStore().getMaxSize();
    }

    private SimpleString extractGroupID(MessageReference ref) {
        if (this.internalQueue) {
            return null;
        }
        try {
            return ref.getMessage().getSimpleStringProperty(Message.HDR_GROUP_ID);
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            return null;
        }
    }

    protected void refRemoved(MessageReference ref) {
        this.queueMemorySize.addAndGet(-ref.getMessageMemoryEstimate());
        if (ref.isPaged()) {
            this.pagedReferences.decrementAndGet();
        }
    }

    protected void refAdded(MessageReference ref) {
        if (ref.isPaged()) {
            this.pagedReferences.incrementAndGet();
        }
    }

    private void scheduleDepage(boolean scheduleExpiry) {
        if (!this.depagePending) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Scheduling depage for queue " + this.getName());
            }
            this.depagePending = true;
            this.pageSubscription.getExecutor().execute(new DepageRunner(scheduleExpiry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depage(boolean scheduleExpiry) {
        this.depagePending = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.paused || this.pageIterator == null) {
                return;
            }
        }
        long maxSize = this.pageSubscription.getPagingStore().getPageSizeBytes();
        long timeout = System.currentTimeMillis() + 1000L;
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("QueueMemorySize before depage on queue=" + this.getName() + " is " + this.queueMemorySize.get());
        }
        this.directDeliver = false;
        int depaged = 0;
        while (timeout > System.currentTimeMillis() && this.needsDepage() && this.pageIterator.hasNext()) {
            ++depaged;
            PagedReference reference = (PagedReference)this.pageIterator.next();
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Depaging reference " + reference + " on queue " + this.getName());
            }
            this.addTail(reference, false);
            this.pageIterator.remove();
        }
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            if (depaged == 0 && (long)this.queueMemorySize.get() >= maxSize) {
                ActiveMQServerLogger.LOGGER.debug("Couldn't depage any message as the maxSize on the queue was achieved. There are too many pending messages to be acked in reference to the page configuration");
            }
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("Queue Memory Size after depage on queue=" + this.getName() + " is " + this.queueMemorySize.get() + " with maxSize = " + maxSize + ". Depaged " + depaged + " messages, pendingDelivery=" + this.messageReferences.size() + ", intermediateMessageReferences= " + this.intermediateMessageReferences.size() + ", queueDelivering=" + this.deliveringCount.get());
            }
        }
        this.deliverAsync();
        if (depaged > 0 && scheduleExpiry) {
            this.expireReferences();
        }
    }

    private void internalAddRedistributor(Executor executor) {
        if (this.consumerSet.isEmpty() && this.redistributor == null) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("QueueImpl::Adding redistributor on queue " + this.toString());
            }
            this.redistributor = new Redistributor(this, this.storageManager, this.postOffice, executor, 100);
            this.consumerList.add(new ConsumerHolder(this.redistributor));
            this.consumersChanged = true;
            this.redistributor.start();
            this.deliverAsync();
        }
    }

    @Override
    public boolean checkRedelivery(MessageReference reference, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
        ServerMessage message = reference.getMessage();
        if (this.internalQueue) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Queue " + this.getName() + " is an internal queue, no checkRedelivery");
            }
            return true;
        }
        if (!this.internalQueue && message.isDurable() && this.durable && !reference.isPaged()) {
            this.storageManager.updateDeliveryCount(reference);
        }
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address.toString());
        int maxDeliveries = addressSettings.getMaxDeliveryAttempts();
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        int deliveryCount = reference.getDeliveryCount();
        if (maxDeliveries > 0 && deliveryCount >= maxDeliveries) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Sending reference " + reference + " to DLA = " + addressSettings.getDeadLetterAddress() + " since ref.getDeliveryCount=" + reference.getDeliveryCount() + "and maxDeliveries=" + maxDeliveries + " from queue=" + this.getName());
            }
            this.sendToDeadLetterAddress(reference, addressSettings.getDeadLetterAddress());
            return false;
        }
        if (!ignoreRedeliveryDelay && redeliveryDelay > 0L) {
            redeliveryDelay = this.calculateRedeliveryDelay(addressSettings, deliveryCount);
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Setting redeliveryDelay=" + redeliveryDelay + " on reference=" + reference);
            }
            reference.setScheduledDeliveryTime(timeBase + redeliveryDelay);
            if (!reference.isPaged() && message.isDurable() && this.durable) {
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        this.decDelivering();
        return true;
    }

    public int getNumberOfReferences() {
        return this.messageReferences.size();
    }

    private void move(SimpleString toAddress, Transaction tx, MessageReference ref, boolean expiry, boolean rejectDuplicate) throws Exception {
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(toAddress);
        this.postOffice.route(copyMessage, null, tx, false, rejectDuplicate);
        this.acknowledge(tx, ref);
    }

    private void moveBetweenSnFQueues(SimpleString queueSuffix, Transaction tx, MessageReference ref) throws Exception {
        ServerMessage copyMessage = this.makeCopy(ref, false, false);
        byte[] oldRouteToIDs = null;
        for (SimpleString propName : copyMessage.getPropertyNames()) {
            if (!propName.startsWith(MessageImpl.HDR_ROUTE_TO_IDS)) continue;
            oldRouteToIDs = (byte[])copyMessage.removeProperty(propName);
            String hashcodeToString = oldRouteToIDs.toString();
            ActiveMQServerLogger.LOGGER.debug("Removed property from message: " + propName + " = " + hashcodeToString + " (" + ByteBuffer.wrap(oldRouteToIDs).getLong() + ")");
            break;
        }
        ByteBuffer oldBuffer = ByteBuffer.wrap(oldRouteToIDs);
        RoutingContextImpl routingContext = new RoutingContextImpl(tx);
        while (oldBuffer.hasRemaining()) {
            long oldQueueID = oldBuffer.getLong();
            Pair<String, Binding> result = this.locateTargetBinding(queueSuffix, copyMessage, oldQueueID);
            Binding targetBinding = (Binding)result.getB();
            String targetNodeID = (String)result.getA();
            if (targetBinding == null) {
                ActiveMQServerLogger.LOGGER.unableToFindTargetQueue(targetNodeID);
                continue;
            }
            ActiveMQServerLogger.LOGGER.debug("Routing on binding: " + targetBinding);
            targetBinding.route(copyMessage, routingContext);
        }
        copyMessage.finishCopy();
        this.postOffice.processRoute(copyMessage, routingContext, false);
        ref.handled();
        this.acknowledge(tx, ref);
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorRedistributing(errorCode, errorMessage);
            }

            public void done() {
                QueueImpl.this.deliverAsync();
            }
        });
    }

    private Pair<String, Binding> locateTargetBinding(SimpleString queueSuffix, ServerMessage copyMessage, long oldQueueID) {
        String targetNodeID = null;
        RemoteQueueBinding targetBinding = null;
        block0: for (Map.Entry<SimpleString, Binding> entry : this.postOffice.getAllBindings().entrySet()) {
            RemoteQueueBinding remoteQueueBinding;
            Binding binding = entry.getValue();
            if (!(binding instanceof RemoteQueueBinding) || oldQueueID != (remoteQueueBinding = (RemoteQueueBinding)binding).getRemoteQueueID()) continue;
            SimpleString oldQueueName = remoteQueueBinding.getRoutingName();
            String temp = remoteQueueBinding.getQueue().getName().toString();
            targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
            ActiveMQServerLogger.LOGGER.debug("Message formerly destined for " + oldQueueName + " with ID: " + oldQueueID + " on address " + copyMessage.getAddress() + " on node " + targetNodeID);
            for (Map.Entry<SimpleString, Binding> entry2 : this.postOffice.getAllBindings().entrySet()) {
                binding = entry2.getValue();
                if (!(binding instanceof RemoteQueueBinding)) continue;
                remoteQueueBinding = (RemoteQueueBinding)binding;
                temp = remoteQueueBinding.getQueue().getName().toString();
                targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
                if (oldQueueName.equals((Object)remoteQueueBinding.getRoutingName()) && targetNodeID.equals(queueSuffix.toString())) {
                    targetBinding = remoteQueueBinding;
                    if (!ActiveMQServerLogger.LOGGER.isDebugEnabled()) continue block0;
                    ActiveMQServerLogger.LOGGER.debug("Message now destined for " + remoteQueueBinding.getRoutingName() + " with ID: " + remoteQueueBinding.getRemoteQueueID() + " on address " + copyMessage.getAddress() + " on node " + targetNodeID);
                    continue block0;
                }
                ActiveMQServerLogger.LOGGER.debug("Failed to match: " + remoteQueueBinding);
            }
        }
        return new Pair(targetNodeID, targetBinding);
    }

    private ServerMessage makeCopy(MessageReference ref, boolean expiry) throws Exception {
        return this.makeCopy(ref, expiry, true);
    }

    private ServerMessage makeCopy(MessageReference ref, boolean expiry, boolean copyOriginalHeaders) throws Exception {
        ServerMessage message = ref.getMessage();
        long newID = this.storageManager.generateID();
        ServerMessage copy = message.makeCopyForExpiryOrDLA(newID, ref, expiry, copyOriginalHeaders);
        return copy;
    }

    private void expire(Transaction tx, MessageReference ref) throws Exception {
        SimpleString expiryAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getExpiryAddress();
        if (expiryAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(expiryAddress);
            if (bindingList.getBindings().isEmpty()) {
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoBindings(expiryAddress);
            } else {
                this.move(expiryAddress, tx, ref, true, true);
            }
        } else {
            ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoQueue(this.name);
            this.acknowledge(tx, ref);
        }
    }

    public void sendToDeadLetterAddress(MessageReference ref) throws Exception {
        this.sendToDeadLetterAddress(ref, this.addressSettingsRepository.getMatch(this.address.toString()).getDeadLetterAddress());
    }

    private void sendToDeadLetterAddress(MessageReference ref, SimpleString deadLetterAddress) throws Exception {
        if (deadLetterAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(deadLetterAddress);
            if (bindingList.getBindings().isEmpty()) {
                ActiveMQServerLogger.LOGGER.messageExceededMaxDelivery(ref, deadLetterAddress);
                this.acknowledge(ref);
            } else {
                ActiveMQServerLogger.LOGGER.messageExceededMaxDeliverySendtoDLA(ref, deadLetterAddress, this.name);
                this.move(deadLetterAddress, ref, false, false);
            }
        } else {
            ActiveMQServerLogger.LOGGER.messageExceededMaxDeliveryNoDLA(this.name);
            this.acknowledge(ref);
        }
    }

    private void move(SimpleString address, MessageReference ref, boolean expiry, boolean rejectDuplicate) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(address);
        this.postOffice.route(copyMessage, null, tx, false, rejectDuplicate);
        this.acknowledge(tx, ref);
        tx.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliverDirect(MessageReference ref) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.paused || this.consumerList.isEmpty()) {
                return false;
            }
            if (this.checkExpired(ref)) {
                return true;
            }
            int startPos = this.pos;
            int size = this.consumerList.size();
            do {
                HandleStatus status;
                ConsumerHolder holder = this.consumerList.get(this.pos);
                Consumer consumer = holder.consumer;
                Consumer groupConsumer = null;
                SimpleString groupID = this.extractGroupID(ref);
                if (groupID != null && (groupConsumer = this.groups.get(groupID)) != null) {
                    consumer = groupConsumer;
                }
                if (groupConsumer == null) {
                    ++this.pos;
                }
                if (this.pos == size) {
                    this.pos = 0;
                }
                if ((status = this.handle(ref, consumer)) != HandleStatus.HANDLED) continue;
                if (groupID != null && groupConsumer == null) {
                    this.groups.put(groupID, consumer);
                }
                ++this.messagesAdded;
                this.deliveriesInTransit.countUp();
                this.proceedDeliver(consumer, ref);
                return true;
            } while (this.pos != startPos);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedDeliver(Consumer consumer, MessageReference reference) {
        try {
            consumer.proceedDeliver(reference);
            this.deliveriesInTransit.countDown();
        }
        catch (Throwable t) {
            this.deliveriesInTransit.countDown();
            ActiveMQServerLogger.LOGGER.removingBadConsumer(t, consumer, reference);
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                try {
                    this.removeConsumer(consumer);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
                }
                this.addHead(reference);
            }
        }
    }

    private boolean checkExpired(MessageReference reference) {
        try {
            if (reference.getMessage().isExpired()) {
                if (isTrace) {
                    ActiveMQServerLogger.LOGGER.trace("Reference " + reference + " is expired");
                }
                reference.handled();
                try {
                    this.expire(reference);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringRef(e);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            return false;
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(t, consumer, reference);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConsumerHolder> cloneConsumersList() {
        ArrayList<ConsumerHolder> consumerListClone;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            consumerListClone = new ArrayList<ConsumerHolder>(this.consumerList);
        }
        return consumerListClone;
    }

    @Override
    public void postAcknowledge(MessageReference ref) {
        int count;
        ServerMessage message;
        QueueImpl queue = (QueueImpl)ref.getQueue();
        queue.decDelivering();
        if (ref.isPaged()) {
            return;
        }
        try {
            message = ref.getMessage();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            message = null;
        }
        boolean durableRef = message != null && message.isDurable() && queue.durable;
        try {
            message.decrementRefCount();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorDecrementingRefCount(e);
        }
        if (durableRef && (count = message.decrementDurableRefCount()) == 0) {
            try {
                this.storageManager.deleteMessage(message.getMessageID());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingMessage(e, message.getMessageID());
            }
        }
    }

    void postRollback(LinkedList<MessageReference> refs) {
        this.addHead(refs);
    }

    private long calculateRedeliveryDelay(AddressSettings addressSettings, int deliveryCount) {
        int tmpDeliveryCount;
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        long maxRedeliveryDelay = addressSettings.getMaxRedeliveryDelay();
        double redeliveryMultiplier = addressSettings.getRedeliveryMultiplier();
        long delay = (long)((double)redeliveryDelay * Math.pow(redeliveryMultiplier, tmpDeliveryCount = deliveryCount > 0 ? deliveryCount - 1 : 0));
        if (delay > maxRedeliveryDelay) {
            delay = maxRedeliveryDelay;
        }
        return delay;
    }

    @Override
    public synchronized void resetMessagesAdded() {
        this.messagesAdded = 0L;
    }

    @Override
    public synchronized void resetMessagesAcknowledged() {
        this.messagesAcknowledged = 0L;
    }

    @Override
    public float getRate() {
        float timeSlice = (float)(System.currentTimeMillis() - this.queueRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        if (timeSlice == 0.0f) {
            this.messagesAddedSnapshot.getAndSet(this.messagesAdded);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(this.messagesAdded - this.messagesAddedSnapshot.getAndSet(this.messagesAdded)) / timeSlice).setScale(2, 0).floatValue();
    }

    private int incDelivering() {
        return this.deliveringCount.incrementAndGet();
    }

    public void decDelivering() {
        this.deliveringCount.decrementAndGet();
    }

    private void configureExpiry(AddressSettings settings) {
        this.expiryAddress = settings == null ? null : settings.getExpiryAddress();
    }

    private void configureSlowConsumerReaper(AddressSettings settings) {
        if (settings == null || settings.getSlowConsumerThreshold() == -1L) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
                this.slowConsumerReaperRunnable = null;
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("Cancelled slow-consumer-reaper thread for queue \"" + this.getName() + "\"");
                }
            }
        } else if (this.slowConsumerReaperRunnable == null) {
            this.scheduleSlowConsumerReaper(settings);
        } else if (this.slowConsumerReaperRunnable.checkPeriod != settings.getSlowConsumerCheckPeriod() || this.slowConsumerReaperRunnable.threshold != (float)settings.getSlowConsumerThreshold() || !this.slowConsumerReaperRunnable.policy.equals((Object)settings.getSlowConsumerPolicy())) {
            this.slowConsumerReaperFuture.cancel(false);
            this.scheduleSlowConsumerReaper(settings);
        }
    }

    void scheduleSlowConsumerReaper(AddressSettings settings) {
        this.slowConsumerReaperRunnable = new SlowConsumerReaperRunnable(settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerPolicy());
        this.slowConsumerReaperFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.slowConsumerReaperRunnable, settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerCheckPeriod(), TimeUnit.SECONDS);
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug("Scheduled slow-consumer-reaper thread for queue \"" + this.getName() + "\"; slow-consumer-check-period=" + settings.getSlowConsumerCheckPeriod() + ", slow-consumer-threshold=" + settings.getSlowConsumerThreshold() + ", slow-consumer-policy=" + (Object)((Object)settings.getSlowConsumerPolicy()));
        }
    }

    private final class SlowConsumerReaperRunnable
    implements Runnable {
        private SlowConsumerPolicy policy;
        private float threshold;
        private long checkPeriod;

        public SlowConsumerReaperRunnable(long checkPeriod, float threshold, SlowConsumerPolicy policy) {
            this.checkPeriod = checkPeriod;
            this.policy = policy;
            this.threshold = threshold;
        }

        @Override
        public void run() {
            float queueRate = QueueImpl.this.getRate();
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug(QueueImpl.this.getAddress() + ":" + QueueImpl.this.getName() + " has " + QueueImpl.this.getConsumerCount() + " consumer(s) and is receiving messages at a rate of " + queueRate + " msgs/second.");
            }
            for (Consumer consumer : QueueImpl.this.getConsumers()) {
                if (!(consumer instanceof ServerConsumerImpl)) continue;
                ServerConsumerImpl serverConsumer = (ServerConsumerImpl)consumer;
                float consumerRate = serverConsumer.getRate();
                if (queueRate < this.threshold) {
                    if (!ActiveMQServerLogger.LOGGER.isDebugEnabled()) continue;
                    ActiveMQServerLogger.LOGGER.debug("Insufficient messages received on queue \"" + QueueImpl.this.getName() + "\" to satisfy slow-consumer-threshold. Skipping inspection of consumer.");
                    continue;
                }
                if (!(consumerRate < this.threshold)) continue;
                RemotingConnection connection = null;
                RemotingService remotingService = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer().getRemotingService();
                for (RemotingConnection potentialConnection : remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(serverConsumer.getConnectionID())) continue;
                    connection = potentialConnection;
                }
                if (connection == null) continue;
                ActiveMQServerLogger.LOGGER.slowConsumerDetected(serverConsumer.getSessionID(), serverConsumer.getID(), QueueImpl.this.getName().toString(), connection.getRemoteAddress(), this.threshold, consumerRate);
                if (this.policy.equals((Object)SlowConsumerPolicy.KILL)) {
                    remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(connection.getRemoteAddress()));
                    continue;
                }
                if (!this.policy.equals((Object)SlowConsumerPolicy.NOTIFY)) continue;
                TypedProperties props = new TypedProperties();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, QueueImpl.this.getConsumerCount());
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, QueueImpl.this.address);
                if (connection != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)connection.getRemoteAddress()));
                    if (connection.getID() != null) {
                        props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)connection.getID().toString()));
                    }
                }
                props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, serverConsumer.getID());
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)serverConsumer.getSessionID()));
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_SLOW, props);
                ManagementService managementService = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer().getManagementService();
                try {
                    managementService.sendNotification(notification);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToSendSlowConsumerNotification(notification, e);
                }
            }
        }
    }

    private class AddressSettingsRepositoryListener
    implements HierarchicalRepositoryChangeListener {
        private AddressSettingsRepositoryListener() {
        }

        @Override
        public void onChange() {
            AddressSettings settings = (AddressSettings)QueueImpl.this.addressSettingsRepository.getMatch(QueueImpl.this.address.toString());
            QueueImpl.this.configureExpiry(settings);
            QueueImpl.this.configureSlowConsumerReaper(settings);
        }
    }

    private class TotalQueueIterator
    implements LinkedListIterator<MessageReference> {
        LinkedListIterator<PagedReference> pageIter = null;
        LinkedListIterator<MessageReference> messagesIterator = null;
        Iterator lastIterator = null;

        public TotalQueueIterator() {
            if (QueueImpl.this.pageSubscription != null) {
                this.pageIter = QueueImpl.this.pageSubscription.iterator();
            }
            this.messagesIterator = new SynchronizedIterator((LinkedListIterator<MessageReference>)QueueImpl.this.messageReferences.iterator());
        }

        public boolean hasNext() {
            if (this.messagesIterator != null && this.messagesIterator.hasNext()) {
                this.lastIterator = this.messagesIterator;
                return true;
            }
            if (this.pageIter != null && this.pageIter.hasNext()) {
                this.lastIterator = this.pageIter;
                return true;
            }
            return false;
        }

        public MessageReference next() {
            if (this.messagesIterator != null && this.messagesIterator.hasNext()) {
                MessageReference msg = (MessageReference)this.messagesIterator.next();
                return msg;
            }
            if (this.pageIter != null && this.pageIter.hasNext()) {
                this.lastIterator = this.pageIter;
                return (MessageReference)this.pageIter.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastIterator != null) {
                this.lastIterator.remove();
            }
        }

        public void repeat() {
        }

        public void close() {
            if (this.pageIter != null) {
                this.pageIter.close();
            }
            if (this.messagesIterator != null) {
                this.messagesIterator.close();
            }
        }
    }

    private class SynchronizedIterator
    implements LinkedListIterator<MessageReference> {
        private final LinkedListIterator<MessageReference> iter;

        SynchronizedIterator(LinkedListIterator<MessageReference> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repeat() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.repeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageReference next() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.remove();
            }
        }
    }

    abstract class QueueIterateAction {
        QueueIterateAction() {
        }

        public abstract void actMessage(Transaction var1, MessageReference var2) throws Exception;
    }

    private final class DepageRunner
    implements Runnable {
        final boolean scheduleExpiry;

        public DepageRunner(boolean scheduleExpiry) {
            this.scheduleExpiry = scheduleExpiry;
        }

        @Override
        public void run() {
            try {
                QueueImpl.this.depage(this.scheduleExpiry);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDelivering(e);
            }
        }
    }

    private final class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable runnable = QueueImpl.this.deliverRunner;
                synchronized (runnable) {
                    QueueImpl.this.deliver();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDelivering(e);
            }
            finally {
                QueueImpl.this.scheduledRunners.decrementAndGet();
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final Executor executor1;

        DelayedAddRedistributor(Executor executor) {
            this.executor1 = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor(this.executor1);
                QueueImpl.this.futures.remove(this);
            }
        }
    }

    private static class ConsumerHolder {
        final Consumer consumer;
        LinkedListIterator<MessageReference> iter;

        ConsumerHolder(Consumer consumer) {
            this.consumer = consumer;
        }
    }

    class ExpiryScanner
    implements Runnable {
        public AtomicInteger scannerRunning = new AtomicInteger(0);

        ExpiryScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                if (QueueImpl.this.queueDestroyed) {
                    return;
                }
                LinkedListIterator<MessageReference> iter = QueueImpl.this.iterator();
                try {
                    boolean expired = false;
                    boolean hasElements = false;
                    while (QueueImpl.this.postOffice.isStarted() && iter.hasNext()) {
                        hasElements = true;
                        MessageReference ref = (MessageReference)iter.next();
                        try {
                            if (!ref.getMessage().isExpired()) continue;
                            QueueImpl.this.incDelivering();
                            expired = true;
                            QueueImpl.this.expire(ref);
                            iter.remove();
                            QueueImpl.this.refRemoved(ref);
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.errorExpiringReferencesOnQueue(e, ref);
                        }
                    }
                    if ((!hasElements || expired) && QueueImpl.this.pageIterator != null && QueueImpl.this.pageIterator.hasNext()) {
                        QueueImpl.this.scheduleDepage(true);
                    }
                }
                finally {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable) {}
                    this.scannerRunning.decrementAndGet();
                }
            }
        }
    }
}

