/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ScheduledThreadPoolService;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolManagementUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolAdd
extends AbstractAddStepHandler {
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.THREAD_FACTORY};
    static final AttributeDefinition[] RW_ATTRIBUTES = new AttributeDefinition[0];
    private final ThreadFactoryResolver threadFactoryResolver;
    private final ServiceName serviceNameBase;

    public ScheduledThreadPoolAdd(ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase) {
        super(ATTRIBUTES);
        this.threadFactoryResolver = threadFactoryResolver;
        this.serviceNameBase = serviceNameBase;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolManagementUtils.BaseThreadPoolParameters params = ThreadPoolManagementUtils.parseScheduledThreadPoolParameters(context, operation, model);
        ScheduledThreadPoolService service = new ScheduledThreadPoolService(params.getMaxThreads(), params.getKeepAliveTime());
        ThreadPoolManagementUtils.installThreadPoolService(service, params.getName(), this.serviceNameBase, params.getThreadFactory(), this.threadFactoryResolver, service.getThreadFactoryInjector(), context.getServiceTarget());
    }

    ServiceName getServiceNameBase() {
        return this.serviceNameBase;
    }

    ThreadFactoryResolver getThreadFactoryResolver() {
        return this.threadFactoryResolver;
    }
}

