/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicInteger;

public class MustacheParser {
    public static final String DEFAULT_SM = "{{";
    public static final String DEFAULT_EM = "}}";
    private MustacheFactory mf;

    protected MustacheParser(MustacheFactory mf) {
        this.mf = mf;
    }

    public Mustache compile(String file) {
        Reader reader = this.mf.getReader(file);
        if (reader == null) {
            throw new MustacheException("Failed to find: " + file);
        }
        return this.compile(reader, file);
    }

    public Mustache compile(Reader reader, String file) {
        return this.compile(reader, file, DEFAULT_SM, DEFAULT_EM);
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        return this.compile(reader, null, new AtomicInteger(0), file, sm, em, true);
    }

    public Mustache compile(Reader reader, String file, String sm, String em, boolean startOfLine) {
        return this.compile(reader, null, new AtomicInteger(0), file, sm, em, startOfLine);
    }

    protected Mustache compile(Reader reader, String tag, AtomicInteger currentLine, String file, String sm, String em, boolean startOfLine) throws MustacheException {
        if (reader == null) {
            throw new MustacheException("Reader is null");
        }
        Reader br = reader.markSupported() ? reader : new BufferedReader(reader);
        try {
            int startLine = currentLine.get();
            MustacheVisitor mv = this.mf.createMustacheVisitor();
            boolean onlywhitespace = true;
            boolean iterable = currentLine.get() != 0;
            currentLine.compareAndSet(0, 1);
            StringBuilder out = new StringBuilder();
            try {
                int c;
                while ((c = br.read()) != -1) {
                    if (c == 13) continue;
                    if (c == 10) {
                        currentLine.incrementAndGet();
                        if (!iterable || iterable && !onlywhitespace) {
                            out.append("\n");
                        }
                        out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                        iterable = false;
                        onlywhitespace = true;
                        startOfLine = true;
                        continue;
                    }
                    if (c == sm.charAt(0)) {
                        br.mark(1);
                        if (sm.length() == 1 || br.read() == sm.charAt(1)) {
                            StringBuilder sb = new StringBuilder();
                            while ((c = br.read()) != -1) {
                                br.mark(1);
                                if (c == em.charAt(0)) {
                                    if (em.length() <= 1 || br.read() == em.charAt(1)) break;
                                    br.reset();
                                }
                                sb.append((char)c);
                            }
                            String command = this.mf.translate(sb.toString());
                            char ch = command.charAt(0);
                            String variable = command.substring(1).trim();
                            switch (ch) {
                                case '#': 
                                case '$': 
                                case '<': 
                                case '^': {
                                    boolean oldStartOfLine = startOfLine;
                                    int line = currentLine.get();
                                    Mustache mustache = this.compile(br, variable, currentLine, file, sm, em, startOfLine &= onlywhitespace);
                                    int lines = currentLine.get() - line;
                                    if (!onlywhitespace || lines == 0) {
                                        this.write(mv, out, file, currentLine.intValue(), oldStartOfLine);
                                    }
                                    out = new StringBuilder();
                                    switch (ch) {
                                        case '#': {
                                            mv.iterable(new TemplateContext(sm, em, file, line, startOfLine), variable, mustache);
                                            break;
                                        }
                                        case '^': {
                                            mv.notIterable(new TemplateContext(sm, em, file, line, startOfLine), variable, mustache);
                                            break;
                                        }
                                        case '<': {
                                            mv.extend(new TemplateContext(sm, em, file, line, startOfLine), variable, mustache);
                                            break;
                                        }
                                        case '$': {
                                            mv.name(new TemplateContext(sm, em, file, line, startOfLine), variable, mustache);
                                        }
                                    }
                                    iterable = lines != 0;
                                    break;
                                }
                                case '/': {
                                    if (!onlywhitespace) {
                                        this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    }
                                    if (!variable.equals(tag)) {
                                        throw new MustacheException("Mismatched start/end tags: " + tag + " != " + variable + " in " + file + ":" + currentLine);
                                    }
                                    return mv.mustache(new TemplateContext(sm, em, file, 0, startOfLine));
                                }
                                case '>': {
                                    out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    mv.partial(new TemplateContext(sm, em, file, currentLine.get(), startOfLine &= onlywhitespace), variable);
                                    break;
                                }
                                case '{': {
                                    out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    String name = variable;
                                    if (em.charAt(1) != '}') {
                                        name = variable.substring(0, variable.length() - 1);
                                    } else if (br.read() != 125) {
                                        throw new MustacheException("Improperly closed variable in " + file + ":" + currentLine);
                                    }
                                    String finalName = name;
                                    mv.value(new TemplateContext(sm, em, file, currentLine.get(), false), finalName, false);
                                    break;
                                }
                                case '&': {
                                    out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    mv.value(new TemplateContext(sm, em, file, currentLine.get(), false), variable, false);
                                    break;
                                }
                                case '%': {
                                    String args;
                                    String pragma;
                                    int index;
                                    if (!onlywhitespace) {
                                        out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    }
                                    if ((index = variable.indexOf(" ")) == -1) {
                                        pragma = variable;
                                        args = null;
                                    } else {
                                        pragma = variable.substring(0, index);
                                        args = variable.substring(index + 1);
                                    }
                                    mv.pragma(new TemplateContext(sm, em, file, currentLine.get(), startOfLine), pragma, args);
                                    break;
                                }
                                case '!': {
                                    out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    break;
                                }
                                case '=': {
                                    out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    String delimiters = command.replaceAll("\\s+", "");
                                    int length = delimiters.length();
                                    if (length > 6 || length / 2 * 2 != length) {
                                        throw new MustacheException("Invalid delimiter string");
                                    }
                                    sm = delimiters.substring(1, length / 2);
                                    em = delimiters.substring(length / 2, length - 1);
                                    break;
                                }
                                default: {
                                    if (c == -1) {
                                        throw new MustacheException("Improperly closed variable in " + file + ":" + currentLine);
                                    }
                                    out = this.write(mv, out, file, currentLine.intValue(), startOfLine);
                                    mv.value(new TemplateContext(sm, em, file, currentLine.get(), false), command.trim(), true);
                                }
                            }
                            startOfLine = false;
                            continue;
                        }
                        br.reset();
                    }
                    onlywhitespace = onlywhitespace && (c == 32 || c == 9 || c == 13);
                    out.append((char)c);
                }
                this.write(mv, out, file, currentLine.intValue(), startOfLine);
                if (tag != null) {
                    throw new MustacheException("Failed to close '" + tag + "' tag at line " + startLine);
                }
                br.close();
            }
            catch (IOException e) {
                throw new MustacheException("Failed to read", e);
            }
            mv.eof(new TemplateContext(sm, em, file, currentLine.get(), startOfLine));
            return mv.mustache(new TemplateContext(sm, em, file, 0, startOfLine));
        }
        catch (MustacheException me) {
            try {
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw me;
        }
    }

    private StringBuilder write(MustacheVisitor mv, StringBuilder out, String file, int line, boolean startOfLine) {
        String text = out.toString();
        mv.write(new TemplateContext(null, null, file, line, startOfLine), text);
        return new StringBuilder();
    }
}

