/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.service;

import java.security.Permission;
import java.util.List;
import org.jboss.as.server.security.ServerPermission;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class SecuredServiceRegistry
implements ServiceRegistry {
    public static final Permission PERMISSION = ServerPermission.USE_SERVICE_REGISTRY;
    private final ServiceRegistry delegate;

    public SecuredServiceRegistry(ServiceRegistry delegate) {
        this.delegate = delegate;
    }

    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        SecuredServiceRegistry.checkPermission(PERMISSION);
        return this.delegate.getRequiredService(serviceName);
    }

    public ServiceController<?> getService(ServiceName serviceName) {
        SecuredServiceRegistry.checkPermission(PERMISSION);
        return this.delegate.getService(serviceName);
    }

    public List<ServiceName> getServiceNames() {
        SecuredServiceRegistry.checkPermission(PERMISSION);
        return this.delegate.getServiceNames();
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

