/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DeploymentRepository
implements Service<DeploymentRepository> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ee", "deploymentRepository"});
    private volatile Map<DeploymentModuleIdentifier, DeploymentHolder> modules;
    private final List<DeploymentRepositoryListener> listeners = new ArrayList<DeploymentRepositoryListener>();

    public void start(StartContext context) throws StartException {
        this.modules = Collections.emptyMap();
    }

    public void stop(StopContext context) {
        this.modules = null;
    }

    public DeploymentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DeploymentModuleIdentifier identifier, ModuleDeployment deployment) {
        ArrayList<DeploymentRepositoryListener> listeners;
        DeploymentRepository deploymentRepository = this;
        synchronized (deploymentRepository) {
            HashMap<DeploymentModuleIdentifier, DeploymentHolder> modules = new HashMap<DeploymentModuleIdentifier, DeploymentHolder>(this.modules);
            modules.put(identifier, new DeploymentHolder(deployment));
            this.modules = Collections.unmodifiableMap(modules);
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
        }
        for (DeploymentRepositoryListener listener : listeners) {
            try {
                listener.deploymentAvailable(identifier, deployment);
            }
            catch (Throwable t) {
                EjbLogger.DEPLOYMENT_LOGGER.deploymentAddListenerException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDeployment(DeploymentModuleIdentifier identifier) {
        ArrayList<DeploymentRepositoryListener> listeners;
        DeploymentHolder deployment;
        DeploymentRepository deploymentRepository = this;
        synchronized (deploymentRepository) {
            deployment = this.modules.get(identifier);
            deployment.started = true;
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
        }
        for (DeploymentRepositoryListener listener : listeners) {
            try {
                listener.deploymentStarted(identifier, deployment.deployment);
            }
            catch (Throwable t) {
                EjbLogger.DEPLOYMENT_LOGGER.deploymentAddListenerException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DeploymentRepositoryListener listener) {
        DeploymentRepository deploymentRepository = this;
        synchronized (deploymentRepository) {
            this.listeners.add(listener);
        }
        listener.listenerAdded(this);
    }

    public synchronized void removeListener(DeploymentRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DeploymentModuleIdentifier identifier) {
        ArrayList<DeploymentRepositoryListener> listeners;
        DeploymentRepository deploymentRepository = this;
        synchronized (deploymentRepository) {
            HashMap<DeploymentModuleIdentifier, DeploymentHolder> modules = new HashMap<DeploymentModuleIdentifier, DeploymentHolder>(this.modules);
            modules.remove(identifier);
            this.modules = Collections.unmodifiableMap(modules);
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
        }
        for (DeploymentRepositoryListener listener : listeners) {
            try {
                listener.deploymentRemoved(identifier);
            }
            catch (Throwable t) {
                EjbLogger.DEPLOYMENT_LOGGER.deploymentRemoveListenerException(t);
            }
        }
    }

    public Map<DeploymentModuleIdentifier, ModuleDeployment> getModules() {
        HashMap<DeploymentModuleIdentifier, ModuleDeployment> modules = new HashMap<DeploymentModuleIdentifier, ModuleDeployment>();
        for (Map.Entry<DeploymentModuleIdentifier, DeploymentHolder> entry : this.modules.entrySet()) {
            modules.put(entry.getKey(), entry.getValue().deployment);
        }
        return modules;
    }

    public Map<DeploymentModuleIdentifier, ModuleDeployment> getStartedModules() {
        HashMap<DeploymentModuleIdentifier, ModuleDeployment> modules = new HashMap<DeploymentModuleIdentifier, ModuleDeployment>();
        for (Map.Entry<DeploymentModuleIdentifier, DeploymentHolder> entry : this.modules.entrySet()) {
            if (!entry.getValue().started) continue;
            modules.put(entry.getKey(), entry.getValue().deployment);
        }
        return modules;
    }

    private class DeploymentHolder {
        final ModuleDeployment deployment;
        volatile boolean started = false;

        private DeploymentHolder(ModuleDeployment deployment) {
            this.deployment = deployment;
        }
    }
}

