/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Iterator;
import java.util.function.Function;

public class IteratorMapper<E, S>
implements Iterator<S> {
    private final Iterator<? extends E> iterator;
    private final Function<? super E, ? extends S> function;

    public IteratorMapper(Iterator<? extends E> iterator, Function<? super E, ? extends S> function) {
        if (iterator == null || function == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.function = function;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public S next() {
        E value = this.iterator.next();
        return this.function.apply(value);
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

