/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.CacheRegistry;
import org.wildfly.clustering.server.registry.CacheRegistryFactoryConfiguration;

public class CacheRegistryFactory<K, V>
implements RegistryFactory<K, V> {
    final AtomicReference<RegistryEntryProvider<K, V>> provider = new AtomicReference();
    private final CacheRegistryFactoryConfiguration<K, V> config;

    public CacheRegistryFactory(CacheRegistryFactoryConfiguration<K, V> config) {
        this.config = config;
    }

    public Registry<K, V> createRegistry(RegistryEntryProvider<K, V> provider) {
        if (!this.provider.compareAndSet(null, provider)) {
            throw new IllegalStateException();
        }
        return new CacheRegistry<K, V>(this.config, provider){

            @Override
            public void close() {
                super.close();
                CacheRegistryFactory.this.provider.set(null);
            }
        };
    }
}

