/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.NioBaseServer;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.nio.Buffers;
import org.jgroups.nio.WriteBuffers;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class NioConnection
implements Connection {
    protected SocketChannel channel;
    protected SelectionKey key;
    protected Address peer_addr;
    protected long last_access;
    protected final NioBaseServer server;
    protected final Buffers send_buf;
    protected boolean write_interest_set;
    protected final Lock send_lock = new ReentrantLock();
    protected Buffers recv_buf = new Buffers();
    protected final Lock recv_lock = new ReentrantLock();

    public NioConnection(Address peer_addr, NioBaseServer server) throws Exception {
        this.server = server;
        if (peer_addr == null) {
            throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
        }
        this.peer_addr = peer_addr;
        this.send_buf = new WriteBuffers(server.maxSendBuffers());
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.setSocketParameters(this.channel.socket());
        this.last_access = this.getTimestamp();
    }

    public NioConnection(SocketChannel channel, NioBaseServer server) throws Exception {
        this.channel = channel;
        this.server = server;
        this.setSocketParameters(this.channel.socket());
        channel.configureBlocking(false);
        this.send_buf = new WriteBuffers(server.maxSendBuffers());
        this.peer_addr = server.usePeerConnections() ? null : new IpAddress((InetSocketAddress)channel.getRemoteAddress());
        this.last_access = this.getTimestamp();
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    @Override
    public boolean isExpired(long now) {
        return this.server.connExpireTime() > 0L && now - this.last_access >= this.server.connExpireTime();
    }

    protected void updateLastAccessed() {
        if (this.server.connExpireTime() > 0L) {
            this.last_access = this.getTimestamp();
        }
    }

    @Override
    public Address localAddress() {
        InetSocketAddress local_addr = null;
        if (this.channel != null) {
            try {
                local_addr = (InetSocketAddress)this.channel.getLocalAddress();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return local_addr != null ? new IpAddress(local_addr) : null;
    }

    @Override
    public Address peerAddress() {
        return this.peer_addr;
    }

    public SelectionKey key() {
        return this.key;
    }

    public NioConnection key(SelectionKey k) {
        this.key = k;
        return this;
    }

    public synchronized int registerSelectionKey(int interest_ops) {
        if (this.key == null) {
            return 0;
        }
        this.key.interestOps(this.key.interestOps() | interest_ops);
        return this.key.interestOps();
    }

    public synchronized int clearSelectionKey(int interest_ops) {
        if (this.key == null) {
            return 0;
        }
        this.key.interestOps(this.key.interestOps() & ~interest_ops);
        return this.key.interestOps();
    }

    @Override
    public void connect(Address dest) throws Exception {
        this.connect(dest, this.server.usePeerConnections());
    }

    protected void connect(Address dest, boolean send_local_addr) throws Exception {
        InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
        try {
            if (!this.server.deferClientBinding()) {
                this.channel.bind(new InetSocketAddress(this.server.clientBindAddress(), this.server.clientBindPort()));
            }
            if (this.channel.getLocalAddress() != null && this.channel.getLocalAddress().equals(destAddr)) {
                throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
            }
            this.key = this.server.register(this.channel, 9, this);
            if (Util.connect(this.channel, destAddr) && this.channel.finishConnect()) {
                this.clearSelectionKey(8);
            }
            if (send_local_addr) {
                this.sendLocalAddress(this.server.localAddress());
            }
        }
        catch (Exception t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void send(byte[] buf, int offset, int length) throws Exception {
        this.send(ByteBuffer.wrap(buf, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buf) throws Exception {
        this.send_lock.lock();
        try {
            boolean success = this.send_buf.write(this.channel, buf);
            this.writeInterest(!success);
            if (success) {
                this.updateLastAccessed();
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws Exception {
        this.send_lock.lock();
        try {
            boolean success = this.send_buf.write(this.channel);
            this.writeInterest(!success);
            if (success) {
                this.updateLastAccessed();
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() throws Exception {
        ByteBuffer msg = null;
        Receiver receiver = this.server.receiver();
        this.recv_lock.lock();
        try {
            msg = this.recv_buf.read(this.channel);
            if (msg == null) {
                return;
            }
            if (this.peer_addr == null && this.server.usePeerConnections()) {
                this.peer_addr = this.readPeerAddress(msg);
                this.server.addConnection(this.peer_addr, this);
                return;
            }
            this.updateLastAccessed();
        }
        finally {
            this.recv_lock.unlock();
        }
        if (receiver != null) {
            receiver.receive(this.peer_addr, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(int max_num_msgs_to_receive) throws Exception {
        ByteBuffer msg = null;
        Receiver receiver = this.server.receiver();
        ByteBuffer[] buffers = new ByteBuffer[max_num_msgs_to_receive];
        int index = 0;
        this.recv_lock.lock();
        try {
            while (index < buffers.length && (msg = this.recv_buf.read(this.channel)) != null) {
                if (this.peer_addr == null && this.server.usePeerConnections()) {
                    this.peer_addr = this.readPeerAddress(msg);
                    this.server.addConnection(this.peer_addr, this);
                    continue;
                }
                buffers[index++] = msg;
            }
            this.updateLastAccessed();
        }
        finally {
            this.recv_lock.unlock();
        }
        if (receiver == null) {
            return;
        }
        for (int i = 0; i < buffers.length; ++i) {
            msg = buffers[i];
            if (msg == null) {
                return;
            }
            receiver.receive(this.peer_addr, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.send_lock.lock();
        try {
            if (this.send_buf.remaining() > 0) {
                try {
                    this.send();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Util.close((Closeable)this.channel);
        }
        finally {
            this.send_lock.unlock();
        }
    }

    public String toString() {
        InetSocketAddress local = null;
        InetSocketAddress remote = null;
        try {
            local = this.channel != null ? (InetSocketAddress)this.channel.getLocalAddress() : null;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            remote = this.channel != null ? (InetSocketAddress)this.channel.getRemoteAddress() : null;
        }
        catch (Throwable t) {
            // empty catch block
        }
        String loc = local == null ? "n/a" : local.getHostString() + ":" + local.getPort();
        String rem = remote == null ? "n/a" : remote.getHostString() + ":" + remote.getPort();
        return String.format("<%s --> %s> (%d secs old) [%s] [send_buf: %s, recv_buf: %s] [ops=%d]", loc, rem, TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS), this.status(), this.send_buf, this.recv_buf, this.key != null ? this.key.interestOps() : -1);
    }

    protected String status() {
        if (this.channel == null) {
            return "n/a";
        }
        if (this.isConnected()) {
            return "connected";
        }
        if (this.channel.isConnectionPending()) {
            return "connection pending";
        }
        if (this.isOpen()) {
            return "open";
        }
        return "closed";
    }

    protected long getTimestamp() {
        return this.server.timeService() != null ? this.server.timeService().timestamp() : System.nanoTime();
    }

    protected void writeInterest(boolean register) {
        if (register) {
            if (!this.write_interest_set) {
                this.write_interest_set = true;
                this.registerSelectionKey(4);
            }
        } else if (this.write_interest_set) {
            this.write_interest_set = false;
            this.clearSelectionKey(4);
        }
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        try {
            client_sock.setSendBufferSize(this.server.sendBufferSize());
        }
        catch (IllegalArgumentException ex) {
            this.server.log().error("%s: exception setting send buffer to %d bytes: %s", this.server.localAddress(), this.server.sendBufferSize(), ex);
        }
        try {
            client_sock.setReceiveBufferSize(this.server.receiveBufferSize());
        }
        catch (IllegalArgumentException ex) {
            this.server.log().error("%s: exception setting receive buffer to %d bytes: %s", this.server.localAddress(), this.server.receiveBufferSize(), ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.server.tcpNodelay());
        if (this.server.linger() > 0) {
            client_sock.setSoLinger(true, this.server.linger());
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    protected void sendLocalAddress(Address local_addr) throws Exception {
        try {
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
            out.writeShort(Version.version);
            local_addr.writeTo(out);
            ByteBuffer buf = out.getByteBuffer();
            this.send(buf);
            this.updateLastAccessed();
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    protected Address readPeerAddress(ByteBuffer buf) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf);
        short version = in.readShort();
        if (!Version.isBinaryCompatible(version)) {
            throw new IOException("packet from " + this.channel.getRemoteAddress() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
        }
        IpAddress client_peer_addr = new IpAddress();
        client_peer_addr.readFrom(in);
        this.updateLastAccessed();
        return client_peer_addr;
    }
}

