/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;

public class Tombstone {
    public static final ExcludeTombstonesFilter EXCLUDE_TOMBSTONES = new ExcludeTombstonesFilter();
    private final boolean release;
    private final long[] data;

    public Tombstone(UUID uuid, long timestamp, boolean release) {
        this.data = new long[]{timestamp, uuid.getLeastSignificantBits(), uuid.getMostSignificantBits()};
        this.release = release;
    }

    private Tombstone(long[] data, boolean release) {
        this.data = data;
        this.release = release;
    }

    public long getLastTimestamp() {
        long max = this.data[0];
        for (int i = 3; i < this.data.length; i += 3) {
            max = Math.max(max, this.data[i]);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tombstone{");
        sb.append("release=").append(this.release);
        sb.append(", data={");
        for (int i = 0; i < this.data.length; i += 3) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(new UUID(this.data[i + 2], this.data[i + 1])).append('=').append(this.data[i]);
        }
        sb.append("} }");
        return sb.toString();
    }

    public Tombstone merge(Tombstone old) {
        assert (old != null);
        assert (this.data.length == 3);
        if (this.release) {
            int toRemove = 0;
            for (int i = 0; i < old.data.length; i += 3) {
                if (old.data[i] >= this.data[0] && (this.data[1] != old.data[i + 1] || this.data[2] != old.data[i + 2])) continue;
                toRemove += 3;
            }
            if (old.data.length == toRemove) {
                return this;
            }
            long[] newData = new long[old.data.length - toRemove];
            int j = 0;
            for (int i = 0; i < old.data.length; i += 3) {
                if (old.data[i] < this.data[0] || this.data[1] == old.data[i + 1] && this.data[2] == old.data[i + 2]) continue;
                newData[j] = old.data[i];
                newData[j + 1] = old.data[i + 1];
                newData[j + 2] = old.data[i + 2];
                j += 3;
            }
            return new Tombstone(newData, false);
        }
        long[] newData = Arrays.copyOf(old.data, old.data.length + 3);
        System.arraycopy(this.data, 0, newData, old.data.length, 3);
        return new Tombstone(newData, false);
    }

    public static class ExcludeTombstonesFilterExternalizer
    implements AdvancedExternalizer<ExcludeTombstonesFilter> {
        public Set<Class<? extends ExcludeTombstonesFilter>> getTypeClasses() {
            return Collections.singleton(ExcludeTombstonesFilter.class);
        }

        public Integer getId() {
            return 1202;
        }

        public void writeObject(ObjectOutput output, ExcludeTombstonesFilter object) throws IOException {
        }

        public ExcludeTombstonesFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return EXCLUDE_TOMBSTONES;
        }
    }

    public static class ExcludeTombstonesFilter
    implements KeyValueFilter {
        private ExcludeTombstonesFilter() {
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            return !(value instanceof Tombstone);
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<Tombstone> {
        public Set<Class<? extends Tombstone>> getTypeClasses() {
            return Collections.singleton(Tombstone.class);
        }

        public Integer getId() {
            return 1201;
        }

        public void writeObject(ObjectOutput output, Tombstone tombstone) throws IOException {
            output.writeBoolean(tombstone.release);
            output.writeInt(tombstone.data.length);
            for (int i = 0; i < tombstone.data.length; ++i) {
                output.writeLong(tombstone.data[i]);
            }
        }

        public Tombstone readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean release = input.readBoolean();
            int length = input.readInt();
            long[] data = new long[length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = input.readLong();
            }
            return new Tombstone(data, release);
        }
    }
}

