/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.reader;

import java.util.Map;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.envers.internal.tools.Triple;
import org.jboss.logging.Logger;

public class FirstLevelCache {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)FirstLevelCache.class.getName());
    private final Map<Triple<String, Number, Object>, Object> cache = Tools.newHashMap();
    private final Map<Triple<Object, Number, Object>, String> entityNameCache = Tools.newHashMap();

    public Object get(String entityName, Number revision, Object id) {
        LOG.debugf("Resolving object from First Level Cache: EntityName:%s - primaryKey:%s - revision:%s", entityName, id, revision);
        return this.cache.get(Triple.make(entityName, revision, id));
    }

    public void put(String entityName, Number revision, Object id, Object entity) {
        LOG.debugf("Caching entity on First Level Cache:  - primaryKey:%s - revision:%s - entityName:%s", id, revision, entityName);
        this.cache.put(Triple.make(entityName, revision, id), entity);
    }

    public boolean contains(String entityName, Number revision, Object id) {
        return this.cache.containsKey(Triple.make(entityName, revision, id));
    }

    public void putOnEntityNameCache(Object id, Number revision, Object entity, String entityName) {
        LOG.debugf("Caching entityName on First Level Cache:  - primaryKey:%s - revision:%s - entity:%s -> entityName:%s", new Object[]{id, revision, entity.getClass().getName(), entityName});
        this.entityNameCache.put(Triple.make(id, revision, entity), entityName);
    }

    public String getFromEntityNameCache(Object id, Number revision, Object entity) {
        LOG.debugf("Trying to resolve entityName from First Level Cache: - primaryKey:%s - revision:%s - entity:%s", id, revision, entity);
        return this.entityNameCache.get(Triple.make(id, revision, entity));
    }

    public boolean containsEntityName(Object id, Number revision, Object entity) {
        return this.entityNameCache.containsKey(Triple.make(id, revision, entity));
    }
}

