/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;

public final class ScopedAnalyzer
extends AnalyzerWrapper {
    private Analyzer globalAnalyzer;
    private final Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

    public ScopedAnalyzer(Analyzer globalAnalyzer) {
        this(globalAnalyzer, Collections.emptyMap());
    }

    private ScopedAnalyzer(Analyzer globalAnalyzer, Map<String, Analyzer> scopedAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzer = globalAnalyzer;
        for (Map.Entry<String, Analyzer> entry : scopedAnalyzers.entrySet()) {
            this.addScopedAnalyzer(entry.getKey(), entry.getValue());
        }
    }

    public void setGlobalAnalyzer(Analyzer globalAnalyzer) {
        this.globalAnalyzer = globalAnalyzer;
    }

    public void addScopedAnalyzer(String scope, Analyzer scopedAnalyzer) {
        this.scopedAnalyzers.put(scope, scopedAnalyzer);
    }

    public boolean isCompositeOfSameInstances(ScopedAnalyzer other) {
        if (this.globalAnalyzer != other.globalAnalyzer) {
            return false;
        }
        if (this.scopedAnalyzers.size() != other.scopedAnalyzers.size()) {
            return false;
        }
        for (String fieldname : this.scopedAnalyzers.keySet()) {
            if (this.scopedAnalyzers.get(fieldname) == other.scopedAnalyzers.get(fieldname)) continue;
            return false;
        }
        return true;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            return this.globalAnalyzer;
        }
        return analyzer;
    }

    public ScopedAnalyzer clone() {
        ScopedAnalyzer clone = new ScopedAnalyzer(this.globalAnalyzer, this.scopedAnalyzers);
        return clone;
    }
}

