/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.Sort;

public class FileSortingComparator<T extends IdentityType>
implements Comparator<T> {
    private IdentityQuery<T> identityQuery;

    public FileSortingComparator(IdentityQuery<T> identityQuery) {
        this.identityQuery = identityQuery;
    }

    @Override
    public int compare(T o1, T o2) {
        Set params = this.identityQuery.getSorting();
        int sortResult = 0;
        if (params != null) {
            for (Sort sort : params) {
                QueryParameter queryParameter = sort.getParameter();
                sortResult = this.sortByQueryParameter(queryParameter, o1, o2);
                if (sortResult == 0) continue;
                if (!sort.isAscending()) {
                    return -sortResult;
                }
                return sortResult;
            }
        }
        return sortResult;
    }

    protected int sortByQueryParameter(QueryParameter queryParameter, T o1, T o2) {
        if (AttributeParameter.class.isInstance(queryParameter)) {
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            List attributeProperties = PropertyQueries.createQuery(o1.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{attributeParameter.getName()})).getResultList();
            if (!attributeProperties.isEmpty()) {
                Property property = (Property)attributeProperties.get(0);
                Serializable value1 = (Serializable)property.getValue(o1);
                Serializable value2 = (Serializable)property.getValue(o2);
                if (String.class.equals(value1.getClass())) {
                    return value1.toString().compareTo(value2.toString());
                }
                if (Date.class.isInstance(value1)) {
                    return ((Date)value1).compareTo((Date)value2);
                }
                if (Boolean.class.isInstance(value1)) {
                    return Boolean.valueOf(value1.toString()).compareTo(Boolean.valueOf(value2.toString()));
                }
            }
        } else {
            if (queryParameter.equals(IdentityType.ID)) {
                return o1.getId().compareTo(o2.getId());
            }
            if (queryParameter.equals(IdentityType.ENABLED)) {
                return Boolean.valueOf(o1.isEnabled()).compareTo(o2.isEnabled());
            }
            if (queryParameter.equals(IdentityType.CREATED_DATE)) {
                return o1.getCreatedDate().compareTo(o2.getCreatedDate());
            }
            if (queryParameter.equals(IdentityType.EXPIRY_DATE)) {
                return o1.getExpirationDate().compareTo(o2.getExpirationDate());
            }
        }
        return -1;
    }
}

