/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;

public final class BeanUtils {
    private static final Logger logger = Logger.getLogger(BeanUtils.class.getName());
    private static final String NULL = "null";
    private static boolean disableIsNull = false;
    private static final Map<String, Class<?>> PRIMITIVE_NAME_TYPE_MAP;
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;

    public static String stripPackage(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1, fqn.length());
    }

    public static String stripPackage(Class<?> clazz) {
        String fqn = clazz.getName();
        return fqn.substring(fqn.lastIndexOf(46) + 1, fqn.length());
    }

    public static String stripClass(Class<?> clazz) {
        return clazz.getPackage().getName();
    }

    public static String stripClass(String clazz) {
        return clazz.substring(0, clazz.lastIndexOf(46));
    }

    public static Class<?> getPrimitiveTypeForName(String name) {
        return PRIMITIVE_NAME_TYPE_MAP.get(name);
    }

    public static Class<?> getWrapperTypeFor(Class<?> primitive) {
        return PRIMITIVES_TO_WRAPPERS.get(primitive);
    }

    public static Class<?> findClass(String name) throws ClassNotFoundException {
        if (PRIMITIVE_NAME_TYPE_MAP.containsKey(name)) {
            return PRIMITIVE_NAME_TYPE_MAP.get(name);
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (loader != null) {
                return Class.forName(name, false, loader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static Class<?> findClass(String name, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            try {
                return Class.forName(name, false, loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BeanUtils.findClass(name);
    }

    public static boolean isNullHandlingEnabled() {
        return !disableIsNull;
    }

    public static boolean isNull(String value) {
        return BeanUtils.isNull(value, true, true);
    }

    public static boolean isNull(String value, boolean trim, boolean empty) {
        String trimmed;
        if (disableIsNull) {
            return false;
        }
        if (value == null) {
            return true;
        }
        String string = trimmed = trim ? value.trim() : value;
        if (empty && trimmed.length() == 0) {
            return true;
        }
        return NULL.equalsIgnoreCase(trimmed);
    }

    public static Object convertValue(String text, String typeName) throws ClassNotFoundException, IntrospectionException {
        PropertyEditor editor;
        Class<?> typeClass = BeanUtils.getPrimitiveTypeForName(typeName);
        if (typeClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            typeClass = loader.loadClass(typeName);
        }
        if ((editor = PropertyEditorFinder.getInstance().find(typeClass)) == null) {
            throw new IntrospectionException("No property editor for type=" + typeClass);
        }
        editor.setAsText(text);
        return editor.getValue();
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps) throws IntrospectionException {
        BeanUtils.mapJavaBeanProperties(bean, beanProps, true);
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps, boolean isStrict) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        for (int p = 0; p < props.length; ++p) {
            String fieldName = props[p].getName();
            propertyMap.put(fieldName, props[p]);
        }
        boolean trace = logger.isLoggable(Level.FINEST);
        Iterator<Object> keys = beanProps.keySet().iterator();
        if (trace) {
            logger.finest("Mapping properties for bean: " + bean);
        }
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String text = beanProps.getProperty(name);
            PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
            if (pd == null) {
                char first;
                String exName;
                if (name.length() > 1 && (pd = (PropertyDescriptor)propertyMap.get(exName = Character.toUpperCase(first = name.charAt(0)) + name.substring(1))) == null) {
                    exName = Character.toLowerCase(first) + name.substring(1);
                    pd = (PropertyDescriptor)propertyMap.get(exName);
                }
                if (pd == null) {
                    if (!isStrict) continue;
                    String msg = "No property found for: " + name + " on JavaBean: " + bean;
                    throw new IntrospectionException(msg);
                }
            }
            Method setter = pd.getWriteMethod();
            if (trace) {
                logger.finest("Property editor found for: " + name + ", editor: " + pd + ", setter: " + setter);
            }
            if (setter == null) continue;
            Class<?> ptype = pd.getPropertyType();
            PropertyEditor editor = PropertyEditorFinder.getInstance().find(ptype);
            if (editor == null && trace) {
                logger.finest("Failed to find property editor for: " + name);
            }
            try {
                editor.setAsText(text);
                Object[] args = new Object[]{editor.getValue()};
                setter.invoke(bean, args);
            }
            catch (Exception e) {
                if (!trace) continue;
                logger.log(Level.FINEST, "Failed to write property", e);
            }
        }
    }

    private static void checkDisableNull() {
        if (System.getProperty("org.jboss.common.beans.property.disablenull") != null) {
            disableIsNull = true;
        }
    }

    static {
        try {
            if (System.getSecurityManager() == null) {
                BeanUtils.checkDisableNull();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        BeanUtils.checkDisableNull();
                        return null;
                    }
                });
            }
        }
        catch (Throwable ignored) {
            logger.log(Level.FINE, "Error retrieving system property org.jboss.util.property.diablenull", ignored);
        }
        HashMap<String, Class<Comparable<Boolean>>> tmp = new HashMap<String, Class<Comparable<Boolean>>>();
        tmp.put("boolean", Boolean.TYPE);
        tmp.put("byte", Byte.TYPE);
        tmp.put("char", Character.TYPE);
        tmp.put("short", Short.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("long", Long.TYPE);
        tmp.put("float", Float.TYPE);
        tmp.put("double", Double.TYPE);
        PRIMITIVE_NAME_TYPE_MAP = Collections.unmodifiableMap(tmp);
        HashMap<Class<Object>, Class<Void>> tmp2 = new HashMap<Class<Object>, Class<Void>>();
        tmp2.put(Boolean.TYPE, Boolean.class);
        tmp2.put(Byte.TYPE, Byte.class);
        tmp2.put(Character.TYPE, Character.class);
        tmp2.put(Double.TYPE, Double.class);
        tmp2.put(Float.TYPE, Float.class);
        tmp2.put(Integer.TYPE, Integer.class);
        tmp2.put(Long.TYPE, Long.class);
        tmp2.put(Short.TYPE, Short.class);
        tmp2.put(Void.TYPE, Void.class);
        PRIMITIVES_TO_WRAPPERS = Collections.unmodifiableMap(tmp2);
    }
}

