/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.rar;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.core.util.Injection;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class ActivationImpl
implements Activation {
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ActivationImpl.class.getName());
    private WeakReference<ResourceAdapter> rar;
    private WeakReference<Class<?>> activationSpecClass;
    private Map<String, Class<?>> configProperties;
    private Set<String> requiredConfigProperties;
    private Map<String, String> valueProperties;

    ActivationImpl(ResourceAdapter rar, Class<?> activationSpecClass, Map<String, Class<?>> configProperties, Set<String> requiredConfigProperties, Map<String, String> valueProperties) {
        this.rar = new WeakReference<ResourceAdapter>(rar);
        this.activationSpecClass = new WeakReference(activationSpecClass);
        this.configProperties = configProperties;
        this.requiredConfigProperties = requiredConfigProperties;
        this.valueProperties = valueProperties;
    }

    public Map<String, Class<?>> getConfigProperties() {
        return this.configProperties;
    }

    public Set<String> getRequiredConfigProperties() {
        return this.requiredConfigProperties;
    }

    public ActivationSpec createInstance() throws NotFoundException, InstantiationException, IllegalAccessException, ResourceException {
        Class clz = (Class)this.activationSpecClass.get();
        if (clz == null) {
            throw new NotFoundException(bundle.activationSpecClassNotAvailable());
        }
        ResourceAdapter ra = (ResourceAdapter)this.rar.get();
        if (ra == null) {
            throw new NotFoundException(bundle.resourceAdapterNotAvailable());
        }
        ActivationSpec instance = (ActivationSpec)ActivationSpec.class.cast(clz.newInstance());
        instance.setResourceAdapter(ra);
        if (this.valueProperties != null && this.valueProperties.size() > 0) {
            Injection injector = new Injection();
            Iterator<Map.Entry<String, String>> it = this.valueProperties.entrySet().iterator();
            while (it.hasNext()) {
                String propertyName = null;
                String propertyValue = null;
                try {
                    Map.Entry<String, String> entry = it.next();
                    propertyName = entry.getKey();
                    propertyValue = entry.getValue();
                    injector.inject(instance, propertyName, propertyValue);
                }
                catch (Throwable t) {
                    log.debugf(t, "Ignoring: %s (%s)", propertyName, propertyValue);
                }
            }
        }
        return instance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ActivationImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[rar=").append(this.rar != null ? this.rar.get() : "null");
        sb.append(" activationSpecClass=").append(this.activationSpecClass != null ? (Serializable)this.activationSpecClass.get() : "null");
        sb.append(" configProperties=").append(this.configProperties);
        sb.append(" requiredConfigProperties=").append(this.requiredConfigProperties);
        sb.append(" valueProperties=").append(this.valueProperties);
        sb.append("]");
        return sb.toString();
    }
}

