/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.lucene40.Lucene40CompoundWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;

@Deprecated
final class Lucene40CompoundReader
extends Directory {
    private final Directory directory;
    private final String fileName;
    protected final int readBufferSize;
    private final Map<String, FileEntry> entries;
    private final boolean openForWrite;
    private static final Map<String, FileEntry> SENTINEL = Collections.emptyMap();
    private final Lucene40CompoundWriter writer;
    private final IndexInput handle;
    private int version;
    private boolean isOpen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lucene40CompoundReader(Directory directory, String fileName, IOContext context, boolean openForWrite) throws IOException {
        this.directory = directory;
        this.fileName = fileName;
        this.readBufferSize = BufferedIndexInput.bufferSize((IOContext)context);
        this.isOpen = false;
        this.openForWrite = openForWrite;
        if (!openForWrite) {
            block5: {
                boolean success = false;
                this.handle = directory.openInput(fileName, context);
                try {
                    this.entries = this.readEntries(directory, fileName);
                    if (this.version >= 1) {
                        CodecUtil.checkHeader((DataInput)this.handle, (String)"CompoundFileWriterData", (int)this.version, (int)this.version);
                        CodecUtil.retrieveChecksum((IndexInput)this.handle);
                    }
                    if (success = true) break block5;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.handle});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.handle});
            }
            this.isOpen = true;
            this.writer = null;
            return;
        }
        assert (!(directory instanceof Lucene40CompoundReader)) : "compound file inside of compound file: " + fileName;
        this.entries = SENTINEL;
        this.isOpen = true;
        this.writer = new Lucene40CompoundWriter(directory, fileName, context);
        this.handle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, FileEntry> readEntries(Directory dir, String name) throws IOException {
        HashMap<String, FileEntry> mapping;
        block9: {
            ChecksumIndexInput entriesStream;
            block8: {
                entriesStream = null;
                mapping = null;
                boolean success = false;
                try {
                    String entriesFileName = IndexFileNames.segmentFileName((String)IndexFileNames.stripExtension((String)name), (String)"", (String)"cfe");
                    entriesStream = dir.openChecksumInput(entriesFileName, IOContext.READONCE);
                    this.version = CodecUtil.checkHeader((DataInput)entriesStream, (String)"CompoundFileWriterEntries", (int)0, (int)1);
                    int numEntries = entriesStream.readVInt();
                    mapping = new HashMap<String, FileEntry>(numEntries);
                    for (int i = 0; i < numEntries; ++i) {
                        FileEntry fileEntry = new FileEntry();
                        String id = entriesStream.readString();
                        FileEntry previous = mapping.put(id, fileEntry);
                        if (previous != null) {
                            throw new CorruptIndexException("Duplicate cfs entry id=" + id + " in CFS ", (DataInput)entriesStream);
                        }
                        fileEntry.offset = entriesStream.readLong();
                        fileEntry.length = entriesStream.readLong();
                    }
                    if (this.version >= 1) {
                        CodecUtil.checkFooter((ChecksumIndexInput)entriesStream);
                    } else {
                        CodecUtil.checkEOF((IndexInput)entriesStream);
                    }
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{entriesStream});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{entriesStream});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{entriesStream});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{entriesStream});
        }
        return mapping;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public synchronized void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        if (this.writer != null) {
            assert (this.openForWrite);
            this.writer.close();
        } else {
            IOUtils.close((Closeable[])new Closeable[]{this.handle});
        }
    }

    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        assert (!this.openForWrite);
        String id = IndexFileNames.stripSegmentName((String)name);
        FileEntry entry = this.entries.get(id);
        if (entry == null) {
            throw new FileNotFoundException("No sub-file with id " + id + " found (fileName=" + name + " files: " + this.entries.keySet() + ")");
        }
        return this.handle.slice(name, entry.offset, entry.length);
    }

    public String[] listAll() {
        String[] res;
        this.ensureOpen();
        if (this.writer != null) {
            res = this.writer.listAll();
        } else {
            res = this.entries.keySet().toArray(new String[this.entries.size()]);
            String seg = IndexFileNames.parseSegmentName((String)this.fileName);
            for (int i = 0; i < res.length; ++i) {
                res[i] = seg + res[i];
            }
        }
        return res;
    }

    public void deleteFile(String name) {
        throw new UnsupportedOperationException();
    }

    public void renameFile(String from, String to) {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        if (this.writer != null) {
            return this.writer.fileLength(name);
        }
        FileEntry e = this.entries.get(IndexFileNames.stripSegmentName((String)name));
        if (e == null) {
            throw new FileNotFoundException(name);
        }
        return e.length;
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        if (!this.openForWrite) {
            throw new UnsupportedOperationException();
        }
        return this.writer.createOutput(name, context);
    }

    public void sync(Collection<String> names) {
        throw new UnsupportedOperationException();
    }

    public Lock obtainLock(String name) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CompoundFileDirectory(file=\"" + this.fileName + "\" in dir=" + this.directory + ")";
    }

    public static final class FileEntry {
        long offset;
        long length;
    }
}

