/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.buffers.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;

public final class ResetLimitWrappedActiveMQBuffer
extends ChannelBufferWrapper {
    private final int limit;
    private MessageInternal message;

    public void setMessage(MessageInternal message) {
        this.message = message;
    }

    public ResetLimitWrappedActiveMQBuffer(int limit, ActiveMQBuffer buffer, MessageInternal message) {
        super(ResetLimitWrappedActiveMQBuffer.unwrap((ByteBuf)buffer.byteBuf()));
        this.limit = limit;
        if (this.writerIndex() < limit) {
            this.writerIndex(limit);
        }
        buffer.readerIndex(limit);
        this.message = message;
    }

    private void changed() {
        if (this.message != null) {
            this.message.bodyChanged();
        }
    }

    public void setBuffer(ActiveMQBuffer buffer) {
        if (this.buffer != null) {
            this.buffer.release();
        }
        this.buffer = buffer.byteBuf();
    }

    public void clear() {
        this.changed();
        this.buffer.clear();
        this.buffer.setIndex(this.limit, this.limit);
    }

    public void readerIndex(int readerIndex) {
        this.changed();
        if (readerIndex < this.limit) {
            readerIndex = this.limit;
        }
        this.buffer.readerIndex(readerIndex);
    }

    public void resetReaderIndex() {
        this.changed();
        this.buffer.readerIndex(this.limit);
    }

    public void resetWriterIndex() {
        this.changed();
        this.buffer.writerIndex(this.limit);
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.changed();
        if (readerIndex < this.limit) {
            readerIndex = this.limit;
        }
        if (writerIndex < this.limit) {
            writerIndex = this.limit;
        }
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    public void writerIndex(int writerIndex) {
        this.changed();
        if (writerIndex < this.limit) {
            writerIndex = this.limit;
        }
        this.buffer.writerIndex(writerIndex);
    }

    public void setByte(int index, byte value) {
        this.changed();
        super.setByte(index, value);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.changed();
        super.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, byte[] src) {
        this.changed();
        super.setBytes(index, src);
    }

    public void setBytes(int index, ByteBuffer src) {
        this.changed();
        super.setBytes(index, src);
    }

    public void setBytes(int index, ActiveMQBuffer src, int srcIndex, int length) {
        this.changed();
        super.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, ActiveMQBuffer src, int length) {
        this.changed();
        super.setBytes(index, src, length);
    }

    public void setBytes(int index, ActiveMQBuffer src) {
        this.changed();
        super.setBytes(index, src);
    }

    public void setChar(int index, char value) {
        this.changed();
        super.setChar(index, value);
    }

    public void setDouble(int index, double value) {
        this.changed();
        super.setDouble(index, value);
    }

    public void setFloat(int index, float value) {
        this.changed();
        super.setFloat(index, value);
    }

    public void setInt(int index, int value) {
        this.changed();
        super.setInt(index, value);
    }

    public void setLong(int index, long value) {
        this.changed();
        super.setLong(index, value);
    }

    public void setShort(int index, short value) {
        this.changed();
        super.setShort(index, value);
    }

    public void writeBoolean(boolean val) {
        this.changed();
        super.writeBoolean(val);
    }

    public void writeByte(byte value) {
        this.changed();
        super.writeByte(value);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.changed();
        super.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(byte[] src) {
        this.changed();
        super.writeBytes(src);
    }

    public void writeBytes(ByteBuffer src) {
        this.changed();
        super.writeBytes(src);
    }

    public void writeBytes(ActiveMQBuffer src, int srcIndex, int length) {
        this.changed();
        super.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(ActiveMQBuffer src, int length) {
        this.changed();
        super.writeBytes(src, length);
    }

    public void writeChar(char chr) {
        this.changed();
        super.writeChar(chr);
    }

    public void writeDouble(double value) {
        this.changed();
        super.writeDouble(value);
    }

    public void writeFloat(float value) {
        this.changed();
        super.writeFloat(value);
    }

    public void writeInt(int value) {
        this.changed();
        super.writeInt(value);
    }

    public void writeLong(long value) {
        this.changed();
        super.writeLong(value);
    }

    public void writeNullableSimpleString(SimpleString val) {
        this.changed();
        super.writeNullableSimpleString(val);
    }

    public void writeNullableString(String val) {
        this.changed();
        super.writeNullableString(val);
    }

    public void writeShort(short value) {
        this.changed();
        super.writeShort(value);
    }

    public void writeSimpleString(SimpleString val) {
        this.changed();
        super.writeSimpleString(val);
    }

    public void writeString(String val) {
        this.changed();
        super.writeString(val);
    }

    public void writeUTF(String utf) {
        this.changed();
        super.writeUTF(utf);
    }
}

