/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.cache.AbstractIdentityCache;
import org.apache.cxf.ws.security.cache.EHCacheUtils;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.wss4j.common.cache.EHCacheManagerHolder;

@ManagedResource
public class EHCacheIdentityCache
extends AbstractIdentityCache
implements Closeable,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(EHCacheIdentityCache.class);
    private Ehcache cache;
    private CacheManager cacheManager;

    public EHCacheIdentityCache(IdentityMapper identityMapper, Bus b) {
        this(identityMapper, EHCacheIdentityCache.class.getName(), b, null);
    }

    public EHCacheIdentityCache(IdentityMapper identityMapper, String key, Bus b, URL configFileURL) {
        super(b, identityMapper);
        if (b != null) {
            ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
            InstrumentationManager im = (InstrumentationManager)b.getExtension(InstrumentationManager.class);
            if (im != null) {
                try {
                    im.register((ManagedComponent)this);
                }
                catch (JMException e) {
                    LOG.log(Level.WARNING, "Registering EHCacheIdentityCache failed.", e);
                }
            }
        }
        this.cacheManager = configFileURL != null ? EHCacheUtils.getCacheManager((Bus)b, (URL)configFileURL) : EHCacheUtils.getCacheManager((Bus)b, (URL)this.getDefaultConfigFileURL());
        CacheConfiguration cc = EHCacheManagerHolder.getCacheConfiguration((String)key, (CacheManager)this.cacheManager);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    @Override
    public void add(String user, String realm, Map<String, String> identities) {
        this.cache.put(new Element((Object)(user + "@" + realm), identities));
    }

    @Override
    @ManagedOperation
    public Map<String, String> get(String user, String realm) {
        Element element = this.cache.get((Serializable)((Object)(user + "@" + realm)));
        if (element != null && !this.cache.isExpired(element)) {
            return (Map)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void remove(String user, String realm) {
        this.cache.remove((Serializable)((Object)(user + "@" + realm)));
    }

    @Override
    @ManagedOperation
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    @ManagedOperation
    public int size() {
        return this.cache.getSize();
    }

    @ManagedOperation
    public String getContent() {
        return this.cache.toString();
    }

    @Override
    public void close() {
        if (this.cacheManager != null) {
            if (this.cache != null) {
                this.cacheManager.removeCache(this.cache.getName());
            }
            EHCacheManagerHolder.releaseCacheManger((CacheManager)this.cacheManager);
            this.cacheManager = null;
            this.cache = null;
            if (super.getBus() != null) {
                ((BusLifeCycleManager)super.getBus().getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }

    private URL getDefaultConfigFileURL() {
        URL url = null;
        if (super.getBus() != null) {
            ResourceManager rm = (ResourceManager)super.getBus().getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource("sts-ehcache.xml", URL.class);
        }
        try {
            if (url == null) {
                url = ClassLoaderUtils.getResource((String)"sts-ehcache.xml", TokenStoreFactory.class);
            }
            if (url == null) {
                url = new URL("sts-ehcache.xml");
            }
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ObjectName getObjectName() throws JMException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.cxf").append(':');
        if (super.getBus() != null) {
            buffer.append("bus.id").append('=').append(super.getBus().getId()).append(',');
        }
        buffer.append("type").append('=').append("EHCacheIdentityCache").append(',');
        buffer.append("name").append('=').append("EHCacheIdentityCache-" + System.identityHashCode(this));
        return new ObjectName(buffer.toString());
    }
}

