/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.weld.deployment.processors.WeldConfiguration;
import org.jboss.as.weld.util.Reflections;
import org.jboss.as.weld.util.Utils;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.modules.Module;

public class DevelopmentModeProcessor
implements DeploymentUnitProcessor {
    private static final String CONTEXT_PARAM_DEV_MODE = "org.jboss.weld.development";
    private static final String PROBE_FILTER_NAME = "weld-probe-filter";
    private static final String PROBE_FILTER_CLASS_NAME = "org.jboss.weld.probe.ProbeFilter";
    private static final String PROBE_EXTENSION_CLASS_NAME = "org.jboss.weld.probe.ProbeExtension";
    private static final FilterMetaData PROBE_FILTER = new FilterMetaData();
    private static final FilterMappingMetaData PROBE_FILTER_MAPPING;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY) == null) {
            return;
        }
        JBossWebMetaData webMetaData = ((WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return;
        }
        if (webMetaData.getContextParams() == null) {
            webMetaData.setContextParams(new ArrayList());
        }
        WeldConfiguration configuration = (WeldConfiguration)Utils.getRootDeploymentUnit(deploymentUnit).getAttachment(WeldConfiguration.ATTACHMENT_KEY);
        boolean devModeContextParam = webMetaData.getContextParams().stream().anyMatch(param -> CONTEXT_PARAM_DEV_MODE.equals(param.getParamName()) && Boolean.valueOf(param.getParamValue()) != false);
        if (!configuration.isDevelopmentMode() && !devModeContextParam) {
            return;
        }
        if (!Reflections.isAccessible(PROBE_FILTER_CLASS_NAME, (ClassLoader)module.getClassLoader())) {
            return;
        }
        if (webMetaData.getFilters() == null) {
            webMetaData.setFilters(new FiltersMetaData());
        }
        if (webMetaData.getFilterMappings() == null) {
            webMetaData.setFilterMappings(new ArrayList());
        }
        webMetaData.getFilters().add((MappableMetaData)PROBE_FILTER);
        webMetaData.getFilterMappings().add(0, PROBE_FILTER_MAPPING);
        Utils.registerAsComponent(PROBE_FILTER_CLASS_NAME, deploymentUnit);
        WeldPortableExtensions.getPortableExtensions(deploymentUnit).tryRegisterExtension(Reflections.loadClass(PROBE_EXTENSION_CLASS_NAME, (ClassLoader)module.getClassLoader()), deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }

    static {
        PROBE_FILTER.setName(PROBE_FILTER_NAME);
        PROBE_FILTER.setFilterClass(PROBE_FILTER_CLASS_NAME);
        PROBE_FILTER_MAPPING = new FilterMappingMetaData();
        PROBE_FILTER_MAPPING.setFilterName(PROBE_FILTER_NAME);
        PROBE_FILTER_MAPPING.setUrlPatterns(Collections.singletonList("/*"));
        PROBE_FILTER_MAPPING.setDispatchers(Collections.singletonList(DispatcherType.REQUEST));
    }
}

