/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;

@Entity
public class SecurityToken {
    @Id
    private String tokenId;
    @Column
    private Date tokenCreationDate = Calendar.getInstance().getTime();
    @Lob
    private byte[] token;

    public SecurityToken() {
    }

    public SecurityToken(String tokenId, Object token) {
        this.tokenId = tokenId;
        this.marshallAndSetToken(token);
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public Date getTokenCreationDate() {
        return this.tokenCreationDate;
    }

    public void setTokenCreationDate(Date tokenCreationDate) {
        this.tokenCreationDate = tokenCreationDate;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public byte[] getToken() {
        return this.token;
    }

    public Object unmarshalToken() {
        try {
            ByteArrayInputStream byteArray = new ByteArrayInputStream(this.getToken());
            return new ObjectInputStream(byteArray).readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Error unmarshalling token.", e);
        }
    }

    private void marshallAndSetToken(Object token) {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArray).writeObject(token);
            this.token = byteArray.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error marshalling token.", e);
        }
    }
}

