/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.nio.charset.Charset;
import org.hibernate.search.exception.SearchException;

public final class MessageSerializationHelper {
    private static final Charset STRING_ENCODING = Charset.forName("UTF-8");

    private MessageSerializationHelper() {
    }

    public static byte[] prependString(String name, byte[] data) {
        byte[] string = name.getBytes(STRING_ENCODING);
        if (string.length > 255) {
            throw new SearchException("Index name is too long to be encoded");
        }
        byte[] result = new byte[data.length + string.length + 1];
        result[0] = MessageSerializationHelper.fromIntToByte(string.length);
        System.arraycopy(string, 0, result, 1, string.length);
        System.arraycopy(data, 0, result, 1 + string.length, data.length);
        return result;
    }

    public static String extractIndexName(int startingOffset, byte[] rawBuffer) {
        int indexNameByteLength = MessageSerializationHelper.fromByteToInt(rawBuffer[startingOffset]);
        return new String(rawBuffer, startingOffset + 1, indexNameByteLength, STRING_ENCODING);
    }

    public static byte[] extractSerializedQueue(int startingOffset, int bufferLength, byte[] rawBuffer) {
        int indexNameByteLength = MessageSerializationHelper.fromByteToInt(rawBuffer[startingOffset]);
        int relevantStartingOffset = startingOffset + 1 + indexNameByteLength;
        byte[] serializedQueue = new byte[bufferLength - 1 - indexNameByteLength];
        System.arraycopy(rawBuffer, relevantStartingOffset, serializedQueue, 0, serializedQueue.length);
        return serializedQueue;
    }

    public static int fromByteToInt(byte b) {
        return b & 0xFF;
    }

    public static byte fromIntToByte(int i) {
        if (i > 255) {
            throw new SearchException("Int is too long to be encoded");
        }
        return (byte)i;
    }
}

