/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.util.Map;
import org.jboss.as.ejb3.component.interceptors.StoredLogDiagnosticContext;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.MDC;
import org.jboss.logging.NDC;

public final class LogDiagnosticContextRecoveryInterceptor
implements Interceptor {
    private static final LogDiagnosticContextRecoveryInterceptor INSTANCE = new LogDiagnosticContextRecoveryInterceptor();
    private static final ImmediateInterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)INSTANCE);

    private LogDiagnosticContextRecoveryInterceptor() {
    }

    public static ImmediateInterceptorFactory getFactory() {
        return FACTORY;
    }

    public static LogDiagnosticContextRecoveryInterceptor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        Map mdc = MDC.getMap();
        if (mdc != null) {
            for (Object str : mdc.keySet()) {
                MDC.remove((String)str);
            }
        }
        StoredLogDiagnosticContext data = (StoredLogDiagnosticContext)context.getPrivateData(StoredLogDiagnosticContext.KEY);
        context.putPrivateData(StoredLogDiagnosticContext.KEY, null);
        if (data != null && data.getMdc() != null) {
            for (Map.Entry object : data.getMdc().entrySet()) {
                MDC.put((String)((String)object.getKey()), object.getValue());
            }
            int depth = NDC.getDepth();
            NDC.push((String)data.getNdc());
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                NDC.setMaxDepth((int)depth);
                for (String str : MDC.getMap().keySet()) {
                    MDC.remove((String)str);
                }
            }
        }
        return context.proceed();
    }
}

